/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import java.io.Serializable;
import java.util.Objects;

public class Parameter
implements Serializable,
Comparable<Parameter> {
    private static final long serialVersionUID = -3788321419921821433L;
    private final String name;
    private final String value;

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value;
    }

    public String getLowerStringValue() {
        return this.value.toLowerCase();
    }

    public String getUpperStringValue() {
        return this.value.toUpperCase();
    }

    public int getIntValue() throws EoulsanException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            throw new EoulsanException("Invalid parameter, an integer parameter is need for " + this.name + " parameter: " + this.value, e);
        }
    }

    public int getIntValueGreaterOrEqualsTo(int min) throws EoulsanException {
        return this.getIntValueInRange(min, Integer.MAX_VALUE);
    }

    public int getIntValueInRange(int min, int max) throws EoulsanException {
        int result = this.getIntValue();
        int minValue = Math.min(min, max);
        int maxValue = Math.max(min, max);
        if (result < minValue) {
            throw new EoulsanException("Invalid " + this.name + "parameter (The value must be greater than " + minValue + "): " + result);
        }
        if (result > maxValue) {
            throw new EoulsanException("Invalid " + this.name + "parameter (The value must be lower than " + maxValue + "): " + result);
        }
        return result;
    }

    public double getDoubleValue() throws EoulsanException {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new EoulsanException("Invalid parameter, an integer parameter is need for " + this.name + " parameter: " + this.value, e);
        }
    }

    public boolean getBooleanValue() {
        return Boolean.parseBoolean(this.value);
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    @Override
    public int compareTo(Parameter p) {
        if (p == null) {
            return -1;
        }
        int result = this.name.compareTo(p.name);
        if (result != 0) {
            return result;
        }
        return this.value.compareTo(p.value);
    }

    public Parameter(String name, String value) {
        if (name == null) {
            throw new NullPointerException("Parameter name can't be null");
        }
        String nameLower = name.toLowerCase().trim();
        if (value == null) {
            throw new NullPointerException("Parameter value can't be null");
        }
        if ("".equals(nameLower)) {
            throw new IllegalArgumentException("Parameter name can't be empty");
        }
        this.name = nameLower;
        this.value = value;
    }
}

