/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepResult;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskResultImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskRunner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractTaskScheduler
implements TaskScheduler {
    private static final int SLEEP_TIME_IN_MS = 500;
    private final Multimap<Step, Integer> submittedContexts;
    private final Multimap<Step, Integer> runningContexts;
    private final Multimap<Step, Integer> doneContexts;
    private final Map<Integer, Step> contexts;
    private final Map<Step, StepStatus> status;
    private final Map<Step, StepResult> results;
    private volatile boolean isStarted;
    private volatile boolean isStopped;
    private volatile boolean isPaused;

    private void addResult(TaskContextImpl context, TaskResultImpl result) {
        this.results.get(this.getStep(context.getId())).addResult(context, result);
    }

    protected Step getStep(TaskContextImpl context) {
        Objects.requireNonNull(context, "context argument cannot be null");
        return this.getStep(context.getId());
    }

    protected Step getStep(int contextId) {
        Preconditions.checkState((boolean)this.contexts.containsKey(contextId), (Object)("The context (" + contextId + ") has never been submitted"));
        return this.contexts.get(contextId);
    }

    private void addRunningContext(TaskContextImpl context) {
        Objects.requireNonNull(context, "context argument cannot be null");
        this.addRunningContext(context.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunningContext(int contextId) {
        this.checkExecutionState();
        Preconditions.checkState((boolean)this.contexts.containsKey(contextId), (Object)("The context (" + contextId + ") has never been submitted"));
        Preconditions.checkState((!this.runningContexts.containsValue((Object)contextId) ? 1 : 0) != 0, (Object)("The context (" + contextId + ") already running"));
        Preconditions.checkState((!this.doneContexts.containsValue((Object)contextId) ? 1 : 0) != 0, (Object)("The context (" + contextId + ") has been already done"));
        Step step = this.getStep(contextId);
        AbstractTaskScheduler abstractTaskScheduler = this;
        synchronized (abstractTaskScheduler) {
            this.runningContexts.put((Object)step, (Object)contextId);
        }
        this.status.get(step).setTaskRunning(contextId);
        EoulsanLogger.getLogger().fine("Scheduler: task #" + contextId + " (step #" + step.getNumber() + " " + step.getId() + ") is running");
    }

    private void addDoneContext(TaskContextImpl context) {
        Objects.requireNonNull(context, "context argument cannot be null");
        this.addDoneContext(context.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDoneContext(int contextId) {
        this.checkExecutionState();
        Preconditions.checkState((boolean)this.contexts.containsKey(contextId), (Object)("The context (" + contextId + ") has never been submitted"));
        Preconditions.checkState((boolean)this.runningContexts.containsValue((Object)contextId), (Object)("The context (" + contextId + ") is not running"));
        Preconditions.checkState((!this.doneContexts.containsValue((Object)contextId) ? 1 : 0) != 0, (Object)("The context (" + contextId + ") has been already done"));
        Step step = this.getStep(contextId);
        AbstractTaskScheduler abstractTaskScheduler = this;
        synchronized (abstractTaskScheduler) {
            this.runningContexts.remove((Object)step, (Object)contextId);
            this.doneContexts.put((Object)step, (Object)contextId);
        }
        this.status.get(step).setTaskDone(contextId);
        EoulsanLogger.getLogger().fine("Scheduler: task #" + contextId + " (step #" + step.getNumber() + " " + step.getId() + ") is done");
    }

    protected void beforeExecuteTask(TaskContextImpl context) {
        Objects.requireNonNull(context, "context argument is null");
        this.checkExecutionState();
        this.addRunningContext(context);
    }

    protected void afterExecuteTask(TaskContextImpl context, TaskResultImpl result) {
        Objects.requireNonNull(context, "context argument is null");
        Objects.requireNonNull(result, "result argument is null");
        this.addResult(context, result);
        this.addDoneContext(context);
    }

    protected TaskResultImpl executeTask(TaskContextImpl context) {
        Objects.requireNonNull(context, "context argument is null");
        Step step = this.getStep(context.getId());
        TaskRunner contextRunner = new TaskRunner(context, this.getStatus(step));
        contextRunner.run();
        return contextRunner.getResult();
    }

    @Override
    public void submit(Step step, Set<TaskContextImpl> contexts) {
        Objects.requireNonNull(contexts, "contexts argument cannot be null");
        for (TaskContextImpl context : contexts) {
            this.submit(step, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Step step, TaskContextImpl context) {
        this.checkExecutionState();
        Objects.requireNonNull(step, "step argument cannot be null");
        Objects.requireNonNull(context, "context argument cannot be null");
        Preconditions.checkState((!this.submittedContexts.containsEntry((Object)step, (Object)context.getId()) ? 1 : 0) != 0, (Object)("The context (#" + context.getId() + ") has been already submitted"));
        AbstractTaskScheduler abstractTaskScheduler = this;
        synchronized (abstractTaskScheduler) {
            if (!this.status.containsKey(step)) {
                this.status.put(step, new StepStatus((AbstractStep)step));
                this.results.put(step, new StepResult((AbstractStep)step));
            }
            this.submittedContexts.put((Object)step, (Object)context.getId());
            this.contexts.put(context.getId(), step);
        }
        this.status.get(step).setTaskSubmitted(context.getId());
        EoulsanLogger.getLogger().fine("Scheduler: task #" + context.getId() + " (step #" + step.getNumber() + " " + step.getId() + ") has been submitted");
    }

    @Override
    public StepStatus getStatus(Step step) {
        return this.status.get(step);
    }

    @Override
    public StepResult getResult(Step step) {
        return this.results.get(step);
    }

    @Override
    public int getTaskSubmittedCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        if (!this.submittedContexts.containsKey((Object)step)) {
            return 0;
        }
        return this.submittedContexts.get((Object)step).size();
    }

    @Override
    public int getTaskRunningCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        if (!this.runningContexts.containsKey((Object)step)) {
            return 0;
        }
        return this.runningContexts.get((Object)step).size();
    }

    @Override
    public int getTaskDoneCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        if (!this.doneContexts.containsKey((Object)step)) {
            return 0;
        }
        return this.doneContexts.get((Object)step).size();
    }

    @Override
    public int getTotalTaskSubmittedCount() {
        return this.submittedContexts.size();
    }

    @Override
    public int getTotalTaskRunningCount() {
        return this.runningContexts.size();
    }

    @Override
    public int getTotalTaskDoneCount() {
        return this.doneContexts.size();
    }

    int getTotalWaitingCount() {
        return this.getTotalTaskSubmittedCount() - this.getTotalTaskRunningCount() - this.getTotalTaskDoneCount();
    }

    @Override
    public void waitEndOfTasks(Step step) {
        this.checkExecutionState();
        while (!(this.isStopped() || this.getTaskRunningCount(step) <= 0 && this.getTaskSubmittedCount(step) <= this.getTaskDoneCount(step))) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                EoulsanLogger.getLogger().severe(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Preconditions.checkState((!this.isStopped ? 1 : 0) != 0, (Object)"The scheduler is stopped");
        AbstractTaskScheduler abstractTaskScheduler = this;
        synchronized (abstractTaskScheduler) {
            this.isStarted = true;
        }
    }

    protected boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.checkExecutionState();
        AbstractTaskScheduler abstractTaskScheduler = this;
        synchronized (abstractTaskScheduler) {
            this.isStopped = true;
        }
    }

    protected boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        this.checkExecutionState();
        Preconditions.checkState((!this.isPaused ? 1 : 0) != 0, (Object)"The execution is already paused");
        AbstractTaskScheduler abstractTaskScheduler = this;
        synchronized (abstractTaskScheduler) {
            this.isPaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        this.checkExecutionState();
        Preconditions.checkState((boolean)this.isPaused, (Object)"The execution is not paused");
        AbstractTaskScheduler abstractTaskScheduler = this;
        synchronized (abstractTaskScheduler) {
            this.isPaused = false;
        }
    }

    boolean isPaused() {
        return this.isPaused;
    }

    private void checkExecutionState() {
        Preconditions.checkState((boolean)this.isStarted, (Object)"The scheduler is not started");
        Preconditions.checkState((!this.isStopped ? 1 : 0) != 0, (Object)"The scheduler is stopped");
    }

    protected AbstractTaskScheduler() {
        HashMultimap mm1 = HashMultimap.create();
        HashMultimap mm2 = HashMultimap.create();
        HashMultimap mm3 = HashMultimap.create();
        this.submittedContexts = Multimaps.synchronizedMultimap((Multimap)mm1);
        this.runningContexts = Multimaps.synchronizedMultimap((Multimap)mm2);
        this.doneContexts = Multimaps.synchronizedMultimap((Multimap)mm3);
        HashMap m1 = new HashMap();
        HashMap m2 = new HashMap();
        HashMap m3 = new HashMap();
        this.contexts = Collections.synchronizedMap(m1);
        this.status = Collections.synchronizedMap(m2);
        this.results = Collections.synchronizedMap(m3);
    }
}

