/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.annotations.ExecutionMode;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.AbstractTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.HadoopCompatibleTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.MonoThreadTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.MultiThreadTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepResult;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import java.util.Objects;
import java.util.Set;

public class CombinedTaskScheduler
implements TaskScheduler,
Runnable {
    private static final int SLEEP_TIME_IN_MS = 200;
    private final AbstractTaskScheduler noTaskScheduler;
    private final AbstractTaskScheduler stdTaskScheduler;
    private final AbstractTaskScheduler ownTaskScheduler;
    private final AbstractTaskScheduler hadoopCompatibleTaskScheduler;
    private volatile boolean isStarted;
    private volatile boolean isStopped;

    @Override
    public void submit(Step step, Set<TaskContextImpl> contexts) {
        Objects.requireNonNull(contexts, "contexts argument cannot be null");
        this.checkExecutionState();
        for (TaskContextImpl context : contexts) {
            this.submit(step, context);
        }
    }

    @Override
    public void submit(Step step, TaskContextImpl context) {
        Objects.requireNonNull(step, "step argument cannot be null");
        Objects.requireNonNull(context, "context argument cannot be null");
        this.checkExecutionState();
        this.getTaskScheduler(step).submit(step, context);
    }

    @Override
    public StepStatus getStatus(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getStatus(step);
    }

    @Override
    public StepResult getResult(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getResult(step);
    }

    @Override
    public int getTaskSubmittedCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getTaskSubmittedCount(step);
    }

    @Override
    public int getTaskRunningCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getTaskRunningCount(step);
    }

    @Override
    public int getTaskDoneCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getTaskDoneCount(step);
    }

    @Override
    public void waitEndOfTasks(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        this.checkExecutionState();
        this.getTaskScheduler(step).waitEndOfTasks(step);
    }

    @Override
    public int getTotalTaskSubmittedCount() {
        return this.noTaskScheduler.getTotalTaskSubmittedCount() + this.stdTaskScheduler.getTotalTaskSubmittedCount() + this.ownTaskScheduler.getTotalTaskSubmittedCount() + (this.hadoopCompatibleTaskScheduler != null ? this.hadoopCompatibleTaskScheduler.getTotalTaskRunningCount() : 0);
    }

    @Override
    public int getTotalTaskRunningCount() {
        return this.noTaskScheduler.getTotalTaskRunningCount() + this.stdTaskScheduler.getTotalTaskRunningCount() + this.ownTaskScheduler.getTotalTaskRunningCount() + (this.hadoopCompatibleTaskScheduler != null ? this.hadoopCompatibleTaskScheduler.getTotalTaskRunningCount() : 0);
    }

    @Override
    public int getTotalTaskDoneCount() {
        return this.noTaskScheduler.getTotalTaskDoneCount() + this.stdTaskScheduler.getTotalTaskDoneCount() + this.ownTaskScheduler.getTotalTaskDoneCount() + (this.hadoopCompatibleTaskScheduler != null ? this.hadoopCompatibleTaskScheduler.getTotalTaskDoneCount() : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        CombinedTaskScheduler combinedTaskScheduler = this;
        synchronized (combinedTaskScheduler) {
            Preconditions.checkState((!this.isStopped ? 1 : 0) != 0, (Object)"The scheduler is stopped");
            this.isStarted = true;
        }
        this.noTaskScheduler.start();
        this.stdTaskScheduler.start();
        this.ownTaskScheduler.start();
        if (this.hadoopCompatibleTaskScheduler != null) {
            this.hadoopCompatibleTaskScheduler.start();
        }
        this.ownTaskScheduler.pause();
        new Thread((Runnable)this, "TaskScheduler_combined").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.checkExecutionState();
        CombinedTaskScheduler combinedTaskScheduler = this;
        synchronized (combinedTaskScheduler) {
            this.isStopped = true;
        }
        this.noTaskScheduler.stop();
        this.stdTaskScheduler.stop();
        this.ownTaskScheduler.stop();
        if (this.hadoopCompatibleTaskScheduler != null) {
            this.hadoopCompatibleTaskScheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExecutionState() {
        CombinedTaskScheduler combinedTaskScheduler = this;
        synchronized (combinedTaskScheduler) {
            Preconditions.checkState((boolean)this.isStarted, (Object)"The scheduler is not started");
            Preconditions.checkState((!this.isStopped ? 1 : 0) != 0, (Object)"The scheduler is stopped");
        }
    }

    private static ParallelizationMode getParallelizationMode(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return ((AbstractStep)step).getParallelizationMode();
    }

    private static ExecutionMode getEoulsanMode(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return ((AbstractStep)step).getEoulsanMode();
    }

    private TaskScheduler getTaskScheduler(Step step) {
        switch (step.getType()) {
            case GENERATOR_STEP: 
            case CHECKER_STEP: {
                return this.stdTaskScheduler;
            }
        }
        switch (CombinedTaskScheduler.getParallelizationMode(step)) {
            case NOT_NEEDED: {
                return this.noTaskScheduler;
            }
            case STANDARD: {
                if (this.hadoopCompatibleTaskScheduler == null) {
                    return this.stdTaskScheduler;
                }
                return CombinedTaskScheduler.getEoulsanMode(step) == ExecutionMode.HADOOP_COMPATIBLE ? this.hadoopCompatibleTaskScheduler : this.stdTaskScheduler;
            }
            case OWN_PARALLELIZATION: {
                return this.ownTaskScheduler;
            }
        }
        throw new IllegalStateException("Unknown Parallelization mode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean stopped;
        CombinedTaskScheduler combinedTaskScheduler = this;
        synchronized (combinedTaskScheduler) {
            stopped = this.isStopped;
        }
        while (!stopped) {
            if (this.ownTaskScheduler.isPaused() && this.ownTaskScheduler.getTotalWaitingCount() > 0) {
                if (!this.stdTaskScheduler.isPaused()) {
                    this.stdTaskScheduler.pause();
                }
                if (this.stdTaskScheduler.getTotalTaskRunningCount() == 0) {
                    this.ownTaskScheduler.resume();
                }
            }
            if (!this.ownTaskScheduler.isPaused() && this.ownTaskScheduler.getTotalTaskRunningCount() == 0 && this.ownTaskScheduler.getTotalWaitingCount() == 0) {
                this.ownTaskScheduler.pause();
                this.stdTaskScheduler.resume();
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                EoulsanLogger.getLogger().severe(e.getMessage());
            }
            combinedTaskScheduler = this;
            synchronized (combinedTaskScheduler) {
                stopped = this.isStopped;
            }
        }
    }

    public CombinedTaskScheduler(int threadNumber) {
        Preconditions.checkArgument((threadNumber > 0 ? 1 : 0) != 0, (Object)"threadNumber must be > 0");
        this.stdTaskScheduler = new MultiThreadTaskScheduler(threadNumber);
        this.noTaskScheduler = new MonoThreadTaskScheduler();
        this.ownTaskScheduler = new MonoThreadTaskScheduler();
        this.hadoopCompatibleTaskScheduler = EoulsanRuntime.getRuntime().getMode().isHadoopMode() ? new HadoopCompatibleTaskScheduler() : null;
    }
}

