/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers;

import com.google.common.collect.Queues;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.AbstractTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskResultImpl;
import java.util.Queue;

public class MonoThreadTaskScheduler
extends AbstractTaskScheduler
implements Runnable {
    private static final int SLEEP_TIME_IN_MS = 100;
    private final Queue<TaskContextImpl> queue = Queues.newLinkedBlockingQueue();

    @Override
    public void submit(Step step, TaskContextImpl context) {
        super.submit(step, context);
        this.queue.add(context);
    }

    @Override
    public void start() {
        super.start();
        new Thread((Runnable)this, "TaskScheduler_mono_thread").start();
    }

    @Override
    public void run() {
        while (!this.isStopped()) {
            if (!this.isPaused() && !this.queue.isEmpty()) {
                TaskContextImpl context = this.queue.remove();
                if (this.isStopped()) {
                    return;
                }
                this.beforeExecuteTask(context);
                if (this.isStopped()) {
                    return;
                }
                TaskResultImpl result = this.executeTask(context);
                if (this.isStopped()) {
                    return;
                }
                this.afterExecuteTask(context, result);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                EoulsanLogger.getLogger().severe(e.getMessage());
            }
        }
    }
}

