/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.ClusterCombinedTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.CombinedTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.ClusterTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.ClusterTaskSchedulerService;

public class TaskSchedulerFactory {
    private static TaskScheduler scheduler;

    public static void initialize() throws EoulsanException {
        Preconditions.checkState((scheduler == null ? 1 : 0) != 0, (Object)"The TaskSchedulerFactory has been already initialized");
        Settings settings = EoulsanRuntime.getSettings();
        int threadNumber = settings.getLocalThreadsNumber();
        if (EoulsanRuntime.getRuntime().getMode() == AbstractEoulsanRuntime.EoulsanExecMode.CLUSTER) {
            String clusterSchedulerName = settings.getClusterSchedulerName();
            if (clusterSchedulerName == null || clusterSchedulerName.trim().isEmpty()) {
                throw new EoulsanException("No cluster scheduler defined. Use the \"main.cluster.scheduler.name\" setting to define it");
            }
            ClusterTaskScheduler clusterScheduler = (ClusterTaskScheduler)ClusterTaskSchedulerService.getInstance().newService(clusterSchedulerName);
            if (clusterScheduler == null) {
                throw new EoulsanException("Unknown cluster scheduler name: " + clusterSchedulerName);
            }
            clusterScheduler.configure(settings);
            scheduler = new ClusterCombinedTaskScheduler(threadNumber, clusterScheduler);
        } else {
            scheduler = new CombinedTaskScheduler(threadNumber);
        }
    }

    public static TaskScheduler getScheduler() {
        Preconditions.checkState((scheduler != null ? 1 : 0) != 0, (Object)"The TaskSchedulerFactory has not been initialized");
        return scheduler;
    }

    private TaskSchedulerFactory() {
    }
}

