/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.EoulsanAnnotationUtils;
import fr.ens.biologie.genomique.eoulsan.core.AbstractPort;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractWorkflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandWorkflowModel;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ExecutorArguments;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputDirectory;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.CopyInputDataModule;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandWorkflow
extends AbstractWorkflow {
    private static final long serialVersionUID = 4132064673361068654L;
    private static final String LATEST_SUFFIX = "-latest";
    static final Set<Parameter> EMPTY_PARAMETERS = Collections.emptySet();
    private final List<CommandStep> steps = new ArrayList<CommandStep>();
    private final Set<String> stepsIds = new HashSet<String>();
    private final CommandWorkflowModel workflowCommand;

    private void addStep(CommandStep step) throws EoulsanException {
        this.addStep(-1, step);
    }

    private void addStep(int pos, CommandStep step) throws EoulsanException {
        if (step == null) {
            throw new EoulsanException("Cannot add null step");
        }
        String stepId = step.getId();
        if (stepId == null) {
            throw new EoulsanException("Cannot add a step with null id");
        }
        if (step.getType() != Step.StepType.GENERATOR_STEP && this.stepsIds.contains(stepId)) {
            throw new EoulsanException("Cannot add step because it already had been added: " + stepId);
        }
        if (step.getType() == Step.StepType.STANDARD_STEP || step.getType() == Step.StepType.GENERATOR_STEP) {
            for (Step.StepType t : Step.StepType.values()) {
                if (!t.name().equals(stepId)) continue;
                throw new EoulsanException("Cannot add a step with a reserved id: " + stepId);
            }
        }
        if (pos == -1) {
            this.steps.add(step);
        } else {
            this.steps.add(pos, step);
        }
        this.stepsIds.add(stepId);
    }

    private int indexOfStep(Step step) {
        if (step == null) {
            return -1;
        }
        return this.steps.indexOf(step);
    }

    private void addMainSteps() throws EoulsanException {
        CommandWorkflowModel c = this.workflowCommand;
        List<String> stepIds = c.getStepIds();
        for (int index = stepIds.size() - 1; index >= 0 && c.isStepSkipped(stepIds.get(index)); --index) {
            stepIds.remove(index);
        }
        for (String stepId : stepIds) {
            String moduleName = c.getModuleName(stepId);
            String stepVersion = c.getStepVersion(stepId);
            Set<Parameter> stepParameters = c.getStepParameters(stepId);
            boolean skip = c.isStepSkipped(stepId);
            Step.DiscardOutput discardOutput = c.getStepDiscardOutput(stepId);
            int requiredMemory = c.getStepRequiredMemory(stepId);
            int requiredProcessors = c.getStepRequiredProcessors(stepId);
            String dataProduct = c.getStepDataProduct(stepId);
            EoulsanLogger.getLogger().info("Create " + (skip ? "skipped step" : "step ") + stepId + " (" + moduleName + ") step.");
            this.addStep(new CommandStep((AbstractWorkflow)this, stepId, moduleName, stepVersion, stepParameters, skip, discardOutput, requiredMemory, requiredProcessors, dataProduct));
        }
        if (this.steps.isEmpty()) {
            throw new EoulsanException("There is no step to execute in the workflow");
        }
    }

    private void addFirstSteps(List<Module> firstModules) throws EoulsanException {
        if (firstModules != null) {
            for (Module module : Utils.listWithoutNull(firstModules)) {
                this.addStep(0, new CommandStep((AbstractWorkflow)this, module));
            }
        }
        this.addStep(0, new CommandStep((AbstractWorkflow)this, Step.StepType.FIRST_STEP));
        this.addStep(0, new CommandStep((AbstractWorkflow)this, Step.StepType.CHECKER_STEP));
        this.addStep(0, new CommandStep((AbstractWorkflow)this, Step.StepType.DESIGN_STEP));
        this.addStep(0, new CommandStep((AbstractWorkflow)this, Step.StepType.ROOT_STEP));
    }

    private void addEndSteps(List<Module> endModules) throws EoulsanException {
        if (endModules == null) {
            return;
        }
        for (Module module : Utils.listWithoutNull(endModules)) {
            this.addStep(new CommandStep((AbstractWorkflow)this, module));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configureSteps() throws EoulsanException {
        for (CommandStep commandStep : this.steps) {
            commandStep.configure();
        }
        ArrayListMultimap requirements = ArrayListMultimap.create();
        for (CommandStep step : this.steps) {
            Set<Requirement> stepRequirements = step.getModule().getRequirements();
            if (stepRequirements == null || stepRequirements.isEmpty()) continue;
            requirements.putAll((Object)step, stepRequirements);
        }
        boolean bl = false;
        for (Map.Entry e : requirements.entries()) {
            void var2_5;
            String stepId = ((CommandStep)e.getKey()).getId();
            Requirement r = (Requirement)e.getValue();
            if (r.isAvailable()) {
                EoulsanLogger.getLogger().fine("Requierement found for step \"" + stepId + "\": " + r);
                continue;
            }
            EoulsanLogger.getLogger().fine("Requierement not found for step \"" + stepId + "\": " + r);
            if (!r.isInstallable()) {
                if (r.isOptional()) continue;
                throw new EoulsanException("Requirement for step \"" + ((CommandStep)e.getKey()).getId() + "\" is not available: " + r.toString());
            }
            CommandStep step = new CommandStep((AbstractWorkflow)this, r.getName() + "install" + (int)(++var2_5), "requirementinstaller", Globals.APP_VERSION.toString(), r.getParameters(), false, Step.DiscardOutput.NO, -1, -1, "");
            step.configure();
            this.addStep(this.indexOfStep(this.getFirstStep()), step);
        }
    }

    private void addDependency(StepInputPort inputPort, StepOutputPort dependencyOutputPort) throws EoulsanException {
        try {
            AbstractStep step = inputPort.getStep();
            AbstractStep dependencyStep = dependencyOutputPort.getStep();
            DataFile stepDir = inputPort.getStep().getStepOutputDirectory();
            DataFile depDir = dependencyOutputPort.getStep().getStepOutputDirectory();
            DataProtocol stepProtocol = stepDir.getProtocol();
            DataProtocol depProtocol = depDir.getProtocol();
            EnumSet<CompressionType> stepCompressionsAllowed = inputPort.getCompressionsAccepted();
            CompressionType depOutputCompression = dependencyOutputPort.getCompression();
            CommandStep newStep = null;
            if ((step.getType() == Step.StepType.STANDARD_STEP || step.getType() == Step.StepType.GENERATOR_STEP) && !step.isSkip() && stepProtocol != depProtocol && inputPort.isRequiredInWorkingDirectory()) {
                newStep = CommandWorkflow.newInputFormatCopyStep(this, inputPort, dependencyOutputPort, depOutputCompression, stepCompressionsAllowed);
            }
            if (!(newStep != null || step.getType() != Step.StepType.STANDARD_STEP && step.getType() != Step.StepType.GENERATOR_STEP || step.isSkip() || inputPort.getCompressionsAccepted().contains(depOutputCompression))) {
                newStep = CommandWorkflow.newInputFormatCopyStep(this, inputPort, dependencyOutputPort, depOutputCompression, stepCompressionsAllowed);
            }
            if (!(newStep != null || step.getType() != Step.StepType.STANDARD_STEP && step.getType() != Step.StepType.GENERATOR_STEP || step.isSkip() || dependencyStep != this.getDesignStep() || EnumSet.allOf(CompressionType.class).containsAll(stepCompressionsAllowed))) {
                newStep = CommandWorkflow.newInputFormatCopyStep(this, inputPort, dependencyOutputPort, depOutputCompression, stepCompressionsAllowed);
            }
            if (newStep != null) {
                this.addStep(this.indexOfStep(step), newStep);
                newStep.addDependency((StepInputPort)newStep.getWorkflowInputPorts().getFirstPort(), dependencyOutputPort);
                step.addDependency(inputPort, (StepOutputPort)newStep.getWorkflowOutputPorts().getFirstPort());
            } else {
                step.addDependency(inputPort, dependencyOutputPort);
            }
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
    }

    private static CommandStep newInputFormatCopyStep(CommandWorkflow workflow, StepInputPort inputPort, StepOutputPort outputPort, CompressionType inputCompression, EnumSet<CompressionType> outputCompressionsAllowed) throws EoulsanException {
        String stepId;
        String stepName = "_copyinputformat";
        HashSet<String> stepsIds = new HashSet<String>();
        for (Step s : workflow.getSteps()) {
            stepsIds.add(s.getId());
        }
        int i = 1;
        do {
            stepId = inputPort.getStep().getId() + "prepare" + i;
            ++i;
        } while (stepsIds.contains(stepId));
        CompressionType comp = outputCompressionsAllowed.contains(inputCompression) ? inputCompression : (outputCompressionsAllowed.contains(CompressionType.NONE) ? CompressionType.NONE : (CompressionType)outputCompressionsAllowed.iterator().next());
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        parameters.add(new Parameter("format", inputPort.getFormat().getName()));
        parameters.add(new Parameter("output.compression", comp.name()));
        parameters.add(new Parameter("output.compressions.allowed", CopyInputDataModule.encodeAllowedCompressionsParameterValue(outputCompressionsAllowed)));
        DataFile outputDirectory = StepOutputDirectory.getInstance().workingDirectory(workflow, inputPort.getStep(), inputPort.getStep().getModule());
        CommandStep step = new CommandStep((AbstractWorkflow)workflow, stepId, "_copyinputformat", null, parameters, false, Step.DiscardOutput.ASAP, -1, -1, "", outputDirectory);
        step.configure();
        return step;
    }

    private static List<CommandStep> newOutputFormatCopyStep(CommandWorkflow workflow, StepOutputPorts outputPorts) throws EoulsanException {
        ArrayList<CommandStep> result = new ArrayList<CommandStep>();
        String stepName = "_copyoutputformat";
        for (StepOutputPort outputPort : outputPorts) {
            String stepId;
            HashSet<String> stepsIds = new HashSet<String>();
            for (Step s : workflow.getSteps()) {
                stepsIds.add(s.getId());
            }
            int i = 1;
            do {
                stepId = ((StepOutputPort)outputPorts.getFirstPort()).getStep().getId() + "finalize" + i;
                ++i;
            } while (stepsIds.contains(stepId));
            HashSet<Parameter> parameters = new HashSet<Parameter>();
            parameters.add(new Parameter("ports", outputPort.getName()));
            parameters.add(new Parameter("formats", outputPort.getFormat().getName()));
            DataFile outputDirectory = StepOutputDirectory.getInstance().workflowDirectory(workflow, outputPort.getStep(), outputPort.getStep().getModule());
            CommandStep step = new CommandStep((AbstractWorkflow)workflow, stepId, "_copyoutputformat", null, parameters, false, Step.DiscardOutput.NO, -1, -1, "", outputDirectory);
            step.configure();
            result.add(step);
        }
        return result;
    }

    private void addManualDependencies() throws EoulsanException {
        HashMap<String, CommandStep> stepsMap = new HashMap<String, CommandStep>();
        for (CommandStep step : this.steps) {
            stepsMap.put(step.getId(), step);
        }
        for (CommandStep toStep : Lists.newArrayList(this.steps)) {
            Map<String, CommandWorkflowModel.StepPort> inputs = this.workflowCommand.getStepInputs(toStep.getId());
            for (Map.Entry<String, CommandWorkflowModel.StepPort> e : inputs.entrySet()) {
                String toPortName = e.getKey();
                String fromStepId = e.getValue().stepId;
                String fromPortName = e.getValue().portName;
                CommandStep fromStep = (CommandStep)stepsMap.get(fromStepId);
                if (fromStep == null) {
                    throw new EoulsanException("No workflow step found with id: " + fromStepId);
                }
                if (!fromStep.getWorkflowOutputPorts().contains(fromPortName)) {
                    throw new EoulsanException("No port with name \"" + fromPortName + "\" found for step with id: " + fromStep.getId());
                }
                if (!toStep.getWorkflowInputPorts().contains(toPortName)) {
                    throw new EoulsanException("No port with name \"" + toPortName + "\" found for step with id: " + toStep.getId());
                }
                StepOutputPort fromPort = (StepOutputPort)fromStep.getWorkflowOutputPorts().getPort(fromPortName);
                StepInputPort toPort = (StepInputPort)toStep.getWorkflowInputPorts().getPort(toPortName);
                this.addDependency(toPort, fromPort);
            }
        }
    }

    private void searchDependencies() throws EoulsanException {
        HashMap<DataFormat, CommandStep> generatorAdded = new HashMap<DataFormat, CommandStep>();
        this.searchDependencies(generatorAdded, null);
        this.searchAllPreviousStepsDependencies();
    }

    private void searchDependencies(Map<DataFormat, CommandStep> generatorAdded, CommandStep lastStepWithoutOutput) throws EoulsanException {
        List<CommandStep> steps = this.steps;
        Object currentLastStepWithoutOutput = lastStepWithoutOutput;
        for (int i = steps.size() - 1; i >= 0; --i) {
            CommandStep step = steps.get(i);
            if (step.getType() == Step.StepType.GENERATOR_STEP && !generatorAdded.containsValue(step)) {
                int generatorIndex = this.indexOfStep(step);
                this.steps.remove(generatorIndex);
                this.steps.add(this.indexOfStep(this.getCheckerStep()) + 1, step);
                if (step.getOutputPorts().isEmpty()) {
                    throw new EoulsanException("Step \"" + step.getId() + "\" is a generator but not generate anything.");
                }
                if (step.getOutputPorts().size() > 1) {
                    throw new EoulsanException("Step \"" + step.getId() + "\" is a generator but generate more than one format.");
                }
                generatorAdded.put(((OutputPort)step.getOutputPorts().getFirstPort()).getFormat(), step);
                this.searchDependencies(generatorAdded, (CommandStep)currentLastStepWithoutOutput);
                return;
            }
            if (EoulsanAnnotationUtils.isRequiresPreviousStep(step.getModule()) || EoulsanAnnotationUtils.isRequiresAllPreviousSteps(step.getModule()) || step.getWorkflowInputPorts().isEmpty() && i > 0) {
                step.addDependency(steps.get(i - 1));
            }
            if (step.getWorkflowOutputPorts().isEmpty()) {
                for (int j = i + 1; j < steps.size(); ++j) {
                    CommandStep s = steps.get(j);
                    s.addDependency(step);
                    if (s == currentLastStepWithoutOutput) break;
                }
                currentLastStepWithoutOutput = step;
            }
            for (Object inputPort : step.getWorkflowInputPorts()) {
                if (((StepInputPort)inputPort).isLinked()) continue;
                DataFormat format = ((AbstractPort)inputPort).getFormat();
                int formatCount = 0;
                for (StepInputPort p : step.getWorkflowInputPorts().getPortsWithDataFormat(format)) {
                    if (p.isLinked()) continue;
                    ++formatCount;
                }
                if (formatCount > 1) {
                    throw new EoulsanException("Step \"" + step.getId() + "\" contains more than one of port of the same format (" + format + "). Please manually define all inputs for this ports.");
                }
                boolean found = false;
                for (int j = i - 1; j >= 0; --j) {
                    CommandStep stepTested = steps.get(j);
                    for (StepOutputPort outputPort : stepTested.getWorkflowOutputPorts().getPortsWithDataFormat(format)) {
                        if (stepTested.getType() != Step.StepType.STANDARD_STEP && stepTested.getType() != Step.StepType.GENERATOR_STEP && stepTested.getType() != Step.StepType.DESIGN_STEP) continue;
                        this.addDependency((StepInputPort)inputPort, outputPort);
                        j = this.indexOfStep(stepTested);
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                i = this.indexOfStep(step);
                if (found || !format.isGenerator()) continue;
                if (!generatorAdded.containsKey(format)) {
                    CommandStep generatorStep = new CommandStep((AbstractWorkflow)this, format);
                    generatorStep.configure();
                    this.addStep(this.indexOfStep(this.getCheckerStep()) + 1, generatorStep);
                    generatorAdded.put(format, generatorStep);
                    this.searchDependencies(generatorAdded, (CommandStep)currentLastStepWithoutOutput);
                    return;
                }
                if (step.getType() == Step.StepType.GENERATOR_STEP) {
                    Collections.swap(this.steps, this.indexOfStep(step), this.indexOfStep(generatorAdded.get(format)));
                    this.searchDependencies(generatorAdded, (CommandStep)currentLastStepWithoutOutput);
                    return;
                }
                throw new EoulsanException("Cannot found input data format \"" + format.getName() + "\" for step " + step.getId() + ".");
            }
        }
        ArrayList<CommandStep> terminalSteps = new ArrayList<CommandStep>();
        for (CommandStep step : this.steps) {
            for (CommandStep terminalStep : terminalSteps) {
                step.addDependency(terminalStep);
            }
            if (!step.isTerminalStep()) continue;
            terminalSteps.add(step);
        }
        StepOutputDirectory dispatcher = StepOutputDirectory.getInstance();
        for (CommandStep step : Lists.newArrayList(this.steps)) {
            if (!step.getDiscardOutput().isCopyResultsToOutput() || step.getStepOutputDirectory().equals(dispatcher.workflowDirectory(this, step, step.getModule())) || step.getWorkflowOutputPorts().isEmpty()) continue;
            List<CommandStep> newSteps = CommandWorkflow.newOutputFormatCopyStep(this, step.getWorkflowOutputPorts());
            for (CommandStep newStep : newSteps) {
                this.addStep(this.indexOfStep(step) + 1, newStep);
                StepInputPort newStepInputPort = (StepInputPort)newStep.getWorkflowInputPorts().getFirstPort();
                newStep.addDependency(newStepInputPort, (StepOutputPort)step.getWorkflowOutputPorts().getPort(newStepInputPort.getName()));
            }
        }
        for (CommandStep step : this.steps) {
            for (StepInputPort inputPort : step.getWorkflowInputPorts()) {
                if (inputPort.isLinked()) continue;
                throw new EoulsanException("The \"" + inputPort.getName() + "\" port (" + inputPort.getFormat().getName() + " format) of step \"" + inputPort.getStep().getId() + "\" is not linked");
            }
        }
    }

    private void searchAllPreviousStepsDependencies() {
        List<CommandStep> steps = this.steps;
        for (int i = 0; i < steps.size(); ++i) {
            CommandStep step = steps.get(i);
            if (!EoulsanAnnotationUtils.isRequiresAllPreviousSteps(step.getModule())) continue;
            HashSet<AbstractStep> dependencies = new HashSet<AbstractStep>();
            this.searchIndirectDependencies(step, dependencies);
            HashSet<CommandStep> newDependencies = new HashSet<CommandStep>(steps);
            newDependencies.removeAll(dependencies);
            for (int j = i; j < steps.size(); ++j) {
                newDependencies.remove(steps.get(j));
            }
            for (AbstractStep abstractStep : newDependencies) {
                step.addDependency(abstractStep);
            }
        }
    }

    private void searchIndirectDependencies(AbstractStep step, Set<AbstractStep> steps) {
        for (AbstractStep s : step.getStepStateDependencies().getRequiredSteps()) {
            if (steps.contains(s)) continue;
            steps.add(s);
            this.searchIndirectDependencies(s, steps);
        }
    }

    private void convertDesignS3URLs() {
        Design design = this.getDesign();
        for (Sample s : design.getSamples()) {
            ArrayList readsSources = Lists.newArrayList(s.getMetadata().getReads());
            for (int i = 0; i < readsSources.size(); ++i) {
                readsSources.set(i, this.convertS3URL((String)readsSources.get(i)));
            }
            s.getMetadata().setReads(readsSources);
        }
        DesignMetadata dmd = design.getMetadata();
        if (dmd.containsGenomeFile()) {
            dmd.setGenomeFile(this.convertS3URL(dmd.getGenomeFile()));
        }
        if (dmd.containsGffFile()) {
            dmd.setGffFile(this.convertS3URL(dmd.getGffFile()));
        }
        if (dmd.containsAdditionalAnnotationFile()) {
            dmd.setAdditionalAnnotationFile(this.convertS3URL(dmd.getAdditionalAnnotationFile()));
        }
    }

    private String convertS3URL(String url) {
        return StringUtils.replacePrefix((String)url, (String)"s3:/", (String)"s3n:/");
    }

    @Override
    protected void saveConfigurationFiles() throws EoulsanException {
        super.saveConfigurationFiles();
        try {
            DataFile jobDir = this.getWorkflowContext().getJobDirectory();
            if (!jobDir.exists()) {
                jobDir.mkdirs();
            }
            DataFile latest = new DataFile(jobDir.getParent(), Globals.APP_NAME_LOWER_CASE + LATEST_SUFFIX);
            try {
                if (latest.exists()) {
                    latest.delete();
                }
                new DataFile(jobDir.getName()).symlink(latest);
            }
            catch (IOException e) {
                EoulsanLogger.getLogger().severe("Cannot create the new shortcut to the jod directory: " + latest);
            }
            BufferedWriter writer = FileUtils.createBufferedWriter((OutputStream)new DataFile(jobDir, "workflow.xml").create());
            writer.write(this.workflowCommand.toXML());
            writer.close();
        }
        catch (EoulsanRuntimeException | IOException e) {
            throw new EoulsanException("Error while writing workflow file: " + e.getMessage(), e);
        }
    }

    public CommandWorkflow(ExecutorArguments executionArguments, CommandWorkflowModel workflowCommand, List<Module> firstSteps, List<Module> endSteps, Design design) throws EoulsanException {
        super(executionArguments, design);
        if (workflowCommand == null) {
            throw new NullPointerException("The command is null.");
        }
        this.workflowCommand = workflowCommand;
        WorkflowContext context = this.getWorkflowContext();
        context.setCommandName(workflowCommand.getName());
        context.setCommandDescription(workflowCommand.getDescription());
        context.setCommandAuthor(workflowCommand.getAuthor());
        DataFormatRegistry.getInstance().reload();
        this.createEoulsanDataDirectoryIfRequired();
        this.convertDesignS3URLs();
        this.addMainSteps();
        this.addFirstSteps(firstSteps);
        this.addEndSteps(endSteps);
        this.configureSteps();
        this.addManualDependencies();
        this.searchDependencies();
    }
}

