/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.core.InputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataProduct;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPorts;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class CrossDataProduct
implements DataProduct,
Serializable {
    private static final long serialVersionUID = 5268549880105535524L;
    public static final String DATAPRODUCT_NAME = "cross";

    CrossDataProduct() {
    }

    @Override
    public String getName() {
        return DATAPRODUCT_NAME;
    }

    @Override
    public void configure(String conf) {
    }

    @Override
    public Set<ImmutableMap<InputPort, Data>> makeProduct(StepInputPorts inputPorts, Multimap<InputPort, Data> inputTokens) {
        Objects.requireNonNull(inputPorts, "inputPorts argument cannot be null");
        Objects.requireNonNull(inputTokens, "inputTokens argument cannot be null");
        HashSet<ImmutableMap<InputPort, Data>> result = new HashSet<ImmutableMap<InputPort, Data>>();
        ArrayList portsList = Lists.newArrayList(inputPorts.iterator());
        ArrayList sets = new ArrayList();
        for (StepInputPort port : portsList) {
            HashSet<CartesianProductEntry> s = new HashSet<CartesianProductEntry>();
            for (Data d : inputTokens.get((Object)port)) {
                s.add(new CartesianProductEntry(port, d));
            }
            sets.add(s);
        }
        Set cartesianProduct = Sets.cartesianProduct(sets);
        for (List l : cartesianProduct) {
            ImmutableMap.Builder imb = ImmutableMap.builder();
            for (CartesianProductEntry e : l) {
                imb.put((Object)e.port, (Object)e.data);
            }
            result.add((ImmutableMap<InputPort, Data>)imb.build());
        }
        return result;
    }

    private static class CartesianProductEntry {
        final StepInputPort port;
        final Data data;

        CartesianProductEntry(StepInputPort port, Data data) {
            this.port = port;
            this.data = data;
        }
    }
}

