/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractData;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataElement;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.workflow.SimpleDataMetadata;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UnmodifiableDataMetadata;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DataList
extends AbstractData
implements Serializable {
    private static final long serialVersionUID = -2933515018143805029L;
    private final List<Data> list = new ArrayList<Data>();
    private final Design design;
    private final StepOutputPort port;

    @Override
    public Data addDataToList(String name) {
        return this.addDataToList(name, -1);
    }

    @Override
    public Data addDataToList(String name, int part) {
        Objects.requireNonNull(name, "name argument cannot be null");
        if (this.port == null) {
            throw new UnsupportedOperationException();
        }
        DataElement result = new DataElement(this.port, this.design);
        ((AbstractData)result).setName(name);
        ((AbstractData)result).setPart(part);
        this.list.add(result);
        return result;
    }

    @Override
    public int getPart() {
        return -1;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public List<Data> getListElements() {
        return Collections.unmodifiableList(this.list);
    }

    List<Data> getModifiableList() {
        return this.list;
    }

    @Override
    public DataMetadata getMetadata() {
        return new UnmodifiableDataMetadata(new SimpleDataMetadata(this.design));
    }

    @Override
    public String getDataFilename() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDataFilename(int fileIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFile getDataFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFile getDataFile(int fileIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDataFileCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDataFileCount(boolean existingFiles) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("format", (Object)this.getFormat().getName()).add("metadata", (Object)this.getMetadata()).add("list", this.isList()).add("elements", this.list).toString();
    }

    DataList(StepInputPort port, Design design) {
        super(port.getFormat());
        Objects.requireNonNull(design, "design argument cannot be null");
        this.port = null;
        this.design = design;
    }

    DataList(StepOutputPort port, Design design) {
        super(port.getFormat());
        Objects.requireNonNull(design, "design argument cannot be null");
        this.port = port;
        this.design = design;
    }

    DataList(DataList data) {
        super(data);
        this.port = data.port;
        this.design = data.design;
        for (Data d : data.getModifiableList()) {
            this.list.add(DataUtils.copy((AbstractData)d));
        }
    }
}

