/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.workflow.SimpleDataMetadata;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowDataUtils;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataMetadataStorage {
    private static final String METADATA_FILENAME = ".eoulsanmetadata";
    private static final String FIELD_SEPARATOR = "\t";
    private static DataMetadataStorage singleton;
    private final DataFile metadataFile;
    private final Map<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();

    public boolean loadMetadata(Data data) {
        Objects.requireNonNull(data, "data argument cannot be null");
        return this.loadMetadata(data, WorkflowDataUtils.getDataFiles(data));
    }

    public boolean loadMetadata(Data data, List<DataFile> files) {
        Objects.requireNonNull(data, "data argument cannot be null");
        Objects.requireNonNull(files, "files argument cannot be null");
        SimpleDataMetadata metadata = WorkflowDataUtils.getSimpleMetadata(data.getMetadata());
        if (metadata == null) {
            return false;
        }
        boolean result = false;
        for (DataFile file : files) {
            String filename = file.getName();
            Map<String, String> entries = this.metadata.get(filename);
            if (entries == null) continue;
            for (Map.Entry<String, String> e : entries.entrySet()) {
                metadata.setRaw(e.getKey(), e.getValue());
            }
            result = true;
        }
        return result;
    }

    public Map<String, String> getMetadata(DataFile file) {
        Objects.requireNonNull(file, "file argument cannot be null");
        Map<String, String> entries = this.metadata.get(file.getName());
        if (entries == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(entries);
    }

    public void saveMetaData(Data data) {
        Objects.requireNonNull(data, "data argument cannot be null");
        if (data.isList()) {
            for (Data d : data.getListElements()) {
                this.saveMetaData(d);
            }
            return;
        }
        SimpleDataMetadata metadata = WorkflowDataUtils.getSimpleMetadata(data.getMetadata());
        if (metadata == null) {
            return;
        }
        List<DataFile> files = WorkflowDataUtils.getDataFiles(data);
        for (DataFile file : files) {
            String filename = file.getName();
            HashMap<String, String> newEntries = new HashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            sb.append(filename);
            for (String key : metadata.keySet()) {
                String value = metadata.getRaw(key);
                newEntries.put(key, value);
                sb.append(FIELD_SEPARATOR);
                sb.append(key);
                sb.append(FIELD_SEPARATOR);
                sb.append(value);
            }
            if (newEntries.equals(this.metadata.get(filename))) continue;
            this.metadata.put(filename, newEntries);
            try {
                this.writeMetadataEntry(sb.toString());
            }
            catch (EoulsanException e) {
                EoulsanLogger.getLogger().warning(e.getMessage());
            }
        }
    }

    private void loadMetaDataEntries() throws EoulsanException {
        if (!this.metadataFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.metadataFile.open(), Globals.DEFAULT_CHARSET));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split(FIELD_SEPARATOR);
                if (fields.length % 2 == 0) continue;
                String filename = fields[0];
                HashMap<String, String> entries = new HashMap<String, String>();
                this.metadata.put(filename, entries);
                for (int i = 1; i < fields.length; i += 2) {
                    entries.put(fields[i], fields[i + 1]);
                }
            }
        }
        catch (IOException e) {
            throw new EoulsanException("Unable to read metadata: " + e.getMessage(), e);
        }
    }

    private void writeMetadataEntry(String s) throws EoulsanException {
        if (!this.metadataFile.isLocalFile()) {
            return;
        }
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.metadataFile.toFile(), true), Globals.DEFAULT_CHARSET));){
            out.println(s);
        }
        catch (IOException e) {
            throw new EoulsanException("Unable to write metadata: " + e.getMessage(), e);
        }
    }

    public static DataMetadataStorage getInstance(DataFile metadataDir) {
        if (singleton == null) {
            singleton = new DataMetadataStorage(metadataDir);
        }
        return singleton;
    }

    private DataMetadataStorage(DataFile metadataDir) {
        Objects.requireNonNull(metadataDir, "metadataDir argument cannot be null");
        this.metadataFile = new DataFile(metadataDir, METADATA_FILENAME);
        try {
            this.loadMetaDataEntries();
        }
        catch (EoulsanException e) {
            EoulsanLogger.getLogger().warning(e.getMessage());
        }
    }
}

