/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.core.workflow.EmergencyStopTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class EmergencyStopTasks {
    private static EmergencyStopTasks instance;
    private final Set<EmergencyStopTask> tasks = Collections.synchronizedSet(new HashSet());
    private volatile boolean stopped;

    public void add(EmergencyStopTask task) {
        Objects.requireNonNull(task, "task argument cannot be null");
        if (this.stopped) {
            task.stop();
        } else {
            this.tasks.add(task);
        }
    }

    public void remove(EmergencyStopTask task) {
        Objects.requireNonNull(task, "task argument cannot be null");
        if (!this.stopped) {
            this.tasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Set<EmergencyStopTask> set = this.tasks;
        synchronized (set) {
            for (EmergencyStopTask task : this.tasks) {
                task.stop();
            }
        }
    }

    public static synchronized EmergencyStopTasks getInstance() {
        if (instance == null) {
            instance = new EmergencyStopTasks();
        }
        return instance;
    }

    private EmergencyStopTasks() {
    }
}

