/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;

public class ExecutorArguments {
    private String localWorkingPathname;
    private String hadoopWorkingPathname;
    private String designPathname;
    private String workflowPathname;
    private String temporaryPathname;
    private String jobDescription = "";
    private String jobEnvironment = "";
    private String outputPathname;
    private String jobPathname;
    private String taskPathname;
    private String dataPathname;
    private final String jobId;
    private final String jobUUID = UUID.randomUUID().toString();
    private final long creationTime;

    public final String getLocalWorkingPathname() {
        return this.localWorkingPathname;
    }

    public final String getHadoopWorkingPathname() {
        return this.hadoopWorkingPathname;
    }

    public final String getJobPathname() {
        return this.jobPathname;
    }

    public final String getTaskPathname() {
        return this.taskPathname;
    }

    public final String getOutputPathname() {
        return this.outputPathname;
    }

    public final String getDesignPathname() {
        return this.designPathname;
    }

    public final String getWorkflowPathname() {
        return this.workflowPathname;
    }

    public final String getTemporaryPathname() {
        return this.temporaryPathname;
    }

    public final String getDataPathname() {
        return this.dataPathname;
    }

    public final String getJobDescription() {
        return this.jobDescription == null ? "" : this.jobDescription.trim();
    }

    public final String getJobEnvironment() {
        return this.jobEnvironment == null ? "" : this.jobEnvironment.trim();
    }

    public final String getJobId() {
        return this.jobId;
    }

    public final String getJobUUID() {
        return this.jobUUID;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final void setLocalWorkingPathname(String localWorkingPath) {
        if (localWorkingPath == null) {
            return;
        }
        this.localWorkingPathname = localWorkingPath.trim();
    }

    public final void setHadoopWorkingPathname(String hadoopWorkingPath) {
        if (hadoopWorkingPath == null) {
            return;
        }
        this.hadoopWorkingPathname = hadoopWorkingPath.trim();
    }

    public final void setJobPathname(String jobPath) {
        if (jobPath == null) {
            return;
        }
        this.jobPathname = jobPath.trim();
    }

    public final void setTaskPathname(String taskPath) {
        if (taskPath == null) {
            return;
        }
        this.taskPathname = taskPath.trim();
    }

    public final void setOutputPathname(String outputPath) {
        if (outputPath == null) {
            return;
        }
        this.outputPathname = outputPath.trim();
    }

    public final void setDesignPathname(String designPathname) {
        if (designPathname == null) {
            return;
        }
        this.designPathname = designPathname.trim();
    }

    public final void setWorkflowPathname(String workflowPathname) {
        if (workflowPathname == null) {
            return;
        }
        this.workflowPathname = workflowPathname.trim();
    }

    public final void setTemporaryPathname(String temporaryPathname) {
        if (temporaryPathname == null) {
            return;
        }
        this.temporaryPathname = temporaryPathname;
    }

    public final void setDataPathname(String dataPathname) {
        if (dataPathname == null) {
            return;
        }
        this.dataPathname = dataPathname;
    }

    public final void setJobDescription(String jobDescription) {
        if (jobDescription == null) {
            return;
        }
        this.jobDescription = jobDescription.trim();
    }

    public final void setJobEnvironment(String jobEnvironment) {
        if (jobEnvironment == null) {
            return;
        }
        this.jobEnvironment = jobEnvironment.trim();
    }

    public InputStream openParamFile() throws IOException {
        return new DataFile(this.getWorkflowPathname()).open();
    }

    public InputStream openDesignFile() throws IOException {
        return new DataFile(this.getDesignPathname()).open();
    }

    public URI logPath(String logFilename) {
        File logDir = new File(URI.create(this.getJobPathname()).getPath());
        return new File(logDir, logFilename).getAbsoluteFile().toURI();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("localWorkingPathname", (Object)this.getLocalWorkingPathname()).add("hadoopWorkingPathname", (Object)this.getHadoopWorkingPathname()).add("designPathname", (Object)this.getDesignPathname()).add("workflowPathname", (Object)this.getWorkflowPathname()).add("jobDescription", (Object)this.getJobDescription()).add("jobEnvironment", (Object)this.getJobEnvironment()).add("outputPathname", (Object)this.getOutputPathname()).add("logPathname", (Object)this.getJobPathname()).add("jobId", (Object)this.getJobId()).add("jobUUID", (Object)this.getJobUUID()).add("creationTime", this.getCreationTime()).toString();
    }

    public ExecutorArguments() {
        this(System.currentTimeMillis());
    }

    public ExecutorArguments(long millisSinceEpoch) {
        this.creationTime = millisSinceEpoch;
        this.jobId = Globals.APP_NAME_LOWER_CASE + "-" + StringUtils.toCompactTime((long)millisSinceEpoch);
    }

    public ExecutorArguments(File workflowFile, File designFile) {
        this();
        Objects.requireNonNull(workflowFile, "The workflow file is null");
        Objects.requireNonNull(designFile, "The design file is null");
        Preconditions.checkArgument((boolean)workflowFile.exists(), (Object)"The workflow file does not exists");
        Preconditions.checkArgument((boolean)designFile.exists(), (Object)"The design file does not exists");
        File outputDir = new File(designFile.getAbsoluteFile().getParent());
        File jobDir = new File(outputDir, this.getJobId());
        File workingDir = new File(jobDir, "working");
        File taskDir = new File(jobDir, "tasks");
        File dataDir = new File(outputDir, Globals.APP_NAME_LOWER_CASE + "-data");
        File tmpDir = new File(jobDir, "tmp");
        this.setLocalWorkingPathname(workingDir.getAbsolutePath());
        this.setDesignPathname(designFile.getAbsolutePath());
        this.setWorkflowPathname(workflowFile.getAbsolutePath());
        this.setOutputPathname(outputDir.getAbsolutePath());
        this.setJobPathname(jobDir.getAbsolutePath());
        this.setTaskPathname(taskDir.getAbsolutePath());
        this.setDataPathname(dataDir.getAbsolutePath());
        this.setTemporaryPathname(tmpDir.getAbsolutePath());
    }
}

