/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractDataMetadata;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowDataUtils;
import fr.ens.biologie.genomique.eoulsan.data.DataMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class SimpleDataMetadata
extends AbstractDataMetadata
implements Serializable {
    private static final long serialVersionUID = -2905676240064559127L;
    private final Design design;
    private final Map<String, String> map = new HashMap<String, String>();
    private static final String STRING_TYPE = "value";
    private static final String SAMPLE_NUMBER_TYPE = "design_sample_id";
    private static final String SAMPLE_NAME_TYPE = "design_sample_name";
    private static final String DESIGN_METADATA_TYPE = "design_metadata";
    private static final String SAMPLE_METADATA_TYPE = "design_sample_metadata";
    private static final String EXPERIMENT_METADATA_TYPE = "design_experiment_sample_metadata";
    private static final char SEPARATOR = ':';

    String getRaw(String key) {
        this.checkKey(key);
        return this.map.get(key);
    }

    @Override
    public String get(String key) {
        String type;
        String value = this.getRaw(key);
        if (value == null) {
            return null;
        }
        switch (type = value.substring(0, value.indexOf(58))) {
            case "value": {
                return value.substring(type.length() + 1);
            }
            case "design_sample_name": {
                String sampleId1 = value.substring(type.length() + 1);
                try {
                    return this.design.getSample(sampleId1).getName();
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            case "design_sample_metadata": {
                int endSampleId = value.indexOf(58, type.length() + 1);
                String sampleId2 = value.substring(type.length() + 1, endSampleId);
                String sampleMDKey = value.substring(endSampleId + 1);
                try {
                    return this.design.getSample(sampleId2).getMetadata().get(sampleMDKey);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            case "design_metadata": {
                String designMDKey = value.substring(type.length() + 1);
                try {
                    return this.design.getMetadata().get(designMDKey);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }
        throw new IllegalStateException("Unknown metadata type: " + type);
    }

    void setRaw(String key, String value) {
        this.checkKey(key);
        Objects.requireNonNull(value, "value argument cannot be null");
        this.map.put(key, value);
    }

    @Override
    public void set(String key, String value) {
        Objects.requireNonNull(value, "value argument cannot be null");
        this.setRaw(key, "value:" + value);
    }

    void setSampleName(Sample sample) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        String value = "design_sample_name:" + sample.getId();
        this.setRaw("SampleName", value);
    }

    void setSampleNumber(Sample sample) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        String value = "design_sample_id:" + sample.getId();
        this.setRaw("SampleNumber", value);
    }

    void setSampleMetadata(Sample sample, String key) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        Objects.requireNonNull(key, "key argument cannot be null");
        Preconditions.checkArgument((boolean)sample.getMetadata().contains(key));
        String value = "design_sample_metadata:" + sample.getId() + ":" + key;
        this.setRaw(key, value);
    }

    void setDesignMetadata(Design design, String key) {
        Objects.requireNonNull(design, "sample argument cannot be null");
        Objects.requireNonNull(key, "key argument cannot be null");
        Preconditions.checkArgument((boolean)design.getMetadata().contains(key));
        String value = "design_metadata:" + key;
        this.setRaw(key, value);
    }

    void setExperimentMetadata(Experiment experiment, String key) {
        Objects.requireNonNull(experiment, "sample argument cannot be null");
        Objects.requireNonNull(key, "key argument cannot be null");
        Preconditions.checkArgument((boolean)experiment.getMetadata().contains(key));
        String value = "design_experiment_sample_metadata:" + key;
        this.setRaw(key, value);
    }

    @Override
    public boolean containsKey(String key) {
        this.checkKey(key);
        return this.map.containsKey(key);
    }

    @Override
    public boolean removeKey(String key) {
        this.checkKey(key);
        this.map.remove(key);
        return true;
    }

    @Override
    public void set(DataMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata argument cannot be null");
        SimpleDataMetadata md = WorkflowDataUtils.getSimpleMetadata(metadata);
        if (md != null) {
            for (Map.Entry<String, String> e : md.map.entrySet()) {
                this.setRaw(e.getKey(), e.getValue());
            }
        } else {
            for (String key : metadata.keySet()) {
                this.set(key, metadata.get(key));
            }
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    public String toString() {
        return this.map.toString();
    }

    private void checkKey(String key) {
        Objects.requireNonNull(key, "key argument cannot be null");
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) >= ' ') continue;
            throw new IllegalArgumentException("Invalid metadata key character found: " + key.charAt(i));
        }
    }

    SimpleDataMetadata(Design design) {
        this.design = design;
    }

    SimpleDataMetadata(SimpleDataMetadata metadata) {
        Objects.requireNonNull(metadata, "data argument cannot be null");
        this.design = metadata.design;
        this.map.putAll(metadata.map);
    }
}

