/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.SimpleInputPort;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

class StepInputPort
extends SimpleInputPort
implements Serializable {
    private static final long serialVersionUID = -3858660424325558424L;
    private final AbstractStep step;
    private StepOutputPort link;

    public AbstractStep getStep() {
        return this.step;
    }

    public StepOutputPort getLink() {
        return this.link;
    }

    public boolean isLinked() {
        return this.link != null;
    }

    public void setLink(StepOutputPort outputPort) {
        Objects.requireNonNull(outputPort, "outputPort argument cannot be null");
        Preconditions.checkArgument((outputPort.getStep() != this.step ? 1 : 0) != 0, (Object)("cannot link a step (" + this.step.getId() + ") to itself (input port: " + this.getName() + ", output port: " + outputPort.getName()));
        if (this.link != null) {
            throw new EoulsanRuntimeException("A link already exists for " + this.getStep().getId() + "." + this.getName() + " (" + this.link.getStep().getId() + "." + this.link.getName() + ")");
        }
        if (!this.getFormat().equals(outputPort.getFormat())) {
            throw new EoulsanRuntimeException("Incompatible format: " + this.getStep().getId() + "." + this.getName() + " -> " + this.getFormat().getName() + " and " + outputPort.getStep().getId() + "." + outputPort.getName() + " <- " + outputPort.getFormat().getName());
        }
        AbstractStep step = outputPort.getStep();
        if (step.getType() != Step.StepType.DESIGN_STEP && step.getType() != Step.StepType.GENERATOR_STEP && step.getType() != Step.StepType.STANDARD_STEP) {
            throw new EoulsanRuntimeException("The dependency (" + step.getId() + ") do not provide port (" + outputPort.getName() + ")");
        }
        this.link = outputPort;
    }

    @Override
    public Set<Step> getLinkedSteps() {
        if (this.link == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.link.getStep());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("format", (Object)this.getFormat().getName()).add("compressionsAccepted", this.getCompressionsAccepted()).add("requiredInWorkingDirectory", this.isRequiredInWorkingDirectory()).add("step", (Object)this.getStep().getId()).add("link", (Object)this.getLink()).toString();
    }

    public StepInputPort(AbstractStep step, String name, boolean list, DataFormat format, EnumSet<CompressionType> compressionsAccepted, boolean requiredInWorkingDirectory) {
        super(name, list, format, compressionsAccepted, requiredInWorkingDirectory);
        if (step == null) {
            throw new NullPointerException("Step is null");
        }
        this.step = step;
    }
}

