/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class StepOutputDataFile
implements Comparable<StepOutputDataFile> {
    private final AbstractStep step;
    private final String portName;
    private final DataFormat format;
    private final Sample sample;
    private final DataFile file;
    private final int fileIndex;
    private final boolean mayNotExist;

    public AbstractStep getStep() {
        return this.step;
    }

    public String getPortName() {
        return this.portName;
    }

    public DataFormat getFormat() {
        return this.format;
    }

    public Sample getSample() {
        return this.sample;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public boolean isMayNotExist() {
        return this.mayNotExist;
    }

    public DataFile getDataFile() {
        return this.file;
    }

    private static DataFile newDataFile(AbstractStep step, String portName, DataFormat format, Sample sample, int fileIndex) {
        Objects.requireNonNull(format, "Format argument cannot be null");
        Objects.requireNonNull(sample, "Sample argument cannot be null");
        switch (step.getType()) {
            case STANDARD_STEP: 
            case GENERATOR_STEP: 
            case DESIGN_STEP: {
                List<String> designValues = StepOutputDataFile.getDesignValues(step.getWorkflow().getDesign(), format, sample);
                return StepOutputDataFile.newDesignDataFile(designValues, format, sample, fileIndex);
            }
        }
        return null;
    }

    private static List<String> getDesignValues(Design design, DataFormat format, Sample sample) {
        DataFormatRegistry registry = DataFormatRegistry.getInstance();
        String designMetadataKey = registry.getDesignMetadataKeyForDataFormat(design, format);
        if (designMetadataKey != null) {
            return design.getMetadata().getAsList(designMetadataKey);
        }
        String sampleMetadataKey = registry.getSampleMetadataKeyForDataFormat(sample, format);
        if (sampleMetadataKey == null) {
            throw new EoulsanRuntimeException("The " + format.getName() + " format was not found in the design file for sample " + sample.getId() + " (" + sample.getName() + ")");
        }
        return sample.getMetadata().getAsList(sampleMetadataKey);
    }

    private static DataFile newDesignDataFile(List<String> fieldValues, DataFormat format, Sample sample, int fileIndex) {
        if (fileIndex >= 0 && fileIndex > fieldValues.size()) {
            return null;
        }
        DataFile file = new DataFile(fieldValues.get(fileIndex == -1 ? 0 : fileIndex));
        if (!StepOutputDataFile.isDesignDataFileValidFormat(file, format)) {
            throw new EoulsanRuntimeException("The file " + file + " in design file is not a " + format.getName() + format.getName() + " format for " + sample.getId() + " (" + sample.getName() + ")");
        }
        return file;
    }

    private static DataFile newStandardDataFile(AbstractStep step, String portName, DataFormat format, Sample sample, int fileIndex, CompressionType compression) {
        StringBuilder sb = new StringBuilder();
        String basePath = step.getStepOutputDirectory().toString();
        if (basePath != null) {
            sb.append(basePath);
            sb.append('/');
        }
        sb.append(StepOutputDataFile.newStandardFilename(step, portName, format, sample, fileIndex, compression));
        return new DataFile(sb.toString());
    }

    private static boolean isDesignDataFileValidFormat(DataFile file, DataFormat df) {
        DataFileMetadata md;
        if (file == null || df == null) {
            return false;
        }
        try {
            md = file.getMetaData();
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().warning("Error while getting metadata for file " + file + ": " + e.getMessage());
            md = null;
        }
        if (md != null && df.equals(md.getDataFormat())) {
            return true;
        }
        DataFormatRegistry dfr = DataFormatRegistry.getInstance();
        for (DataFormat sourceDf : dfr.getDataFormatsFromExtension(file.getExtension())) {
            if (!sourceDf.equals(df)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(StepOutputDataFile o) {
        Objects.requireNonNull(o, "o is null");
        return this.file.compareTo(o.file);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof StepOutputDataFile)) {
            return false;
        }
        StepOutputDataFile that = (StepOutputDataFile)o;
        return Utils.equal((Object)this.file, (Object)that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public static String newStandardFilename(Step step, String portName, DataFormat format, Sample sample, int fileIndex, CompressionType compression) {
        Objects.requireNonNull(step, "step argument cannot be null");
        Objects.requireNonNull(portName, "portName argument cannot be null");
        Objects.requireNonNull(format, "format argument cannot be null");
        Objects.requireNonNull(sample, "sample argument cannot be null");
        Objects.requireNonNull(compression, "compression argument cannot be null");
        StringBuilder sb = new StringBuilder();
        sb.append(step.getId());
        sb.append('_');
        sb.append(format.getName());
        sb.append('_');
        sb.append(format.getName());
        sb.append('_');
        if (format.isOneFilePerAnalysis()) {
            sb.append('0');
        } else {
            sb.append(sample.getId());
        }
        if (fileIndex >= 0) {
            sb.append(StringUtils.toLetter((int)fileIndex));
        }
        sb.append(format.getDefaultExtension());
        sb.append(compression.getExtension());
        return sb.toString();
    }

    public static int dataFileCount(StepOutputPort outputPort, Sample sample, boolean existingFiles) {
        Objects.requireNonNull(outputPort, "outputPort cannot be null");
        Objects.requireNonNull(sample, "Sample argument cannot be null");
        AbstractStep step = outputPort.getStep();
        DataFormat format = outputPort.getFormat();
        CompressionType compression = outputPort.getCompression();
        if (format.getMaxFilesCount() < 2) {
            throw new EoulsanRuntimeException("Only multi-files DataFormat are handled by this method.");
        }
        switch (step.getType()) {
            case STANDARD_STEP: {
                boolean found;
                if (!existingFiles) {
                    return format.getMaxFilesCount();
                }
                int count = 0;
                do {
                    DataFile file;
                    if (!(found = (file = StepOutputDataFile.newStandardDataFile(step, outputPort.getName(), format, sample, count, compression)).exists())) continue;
                    ++count;
                } while (found);
                return count;
            }
            case DESIGN_STEP: {
                return StepOutputDataFile.getDesignValues(step.getWorkflow().getDesign(), format, sample).size();
            }
        }
        return 0;
    }

    public StepOutputDataFile(StepOutputPort outputPort, Sample sample) {
        this(outputPort, sample, -1);
    }

    public StepOutputDataFile(StepOutputPort outputPort, Sample sample, int fileIndex) {
        Objects.requireNonNull(outputPort, "outputPort cannot be null");
        Objects.requireNonNull(sample, "sample cannot be null");
        DataFormat format = outputPort.getFormat();
        if (format.getMaxFilesCount() == 1 && fileIndex != -1) {
            throw new IllegalArgumentException("file index must be used for multi files formats");
        }
        if (format.getMaxFilesCount() > 1 && fileIndex < 0) {
            throw new IllegalArgumentException("file index (" + fileIndex + ") must be greater or equals to 0 for multi files formats (" + format.getName() + ")");
        }
        this.step = outputPort.getStep();
        this.portName = outputPort.getName();
        this.format = format;
        this.sample = format.isOneFilePerAnalysis() ? null : sample;
        this.file = StepOutputDataFile.newDataFile(this.step, this.portName, format, sample, fileIndex);
        this.fileIndex = fileIndex;
        this.mayNotExist = fileIndex > 0;
    }
}

