/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.annotations.EoulsanAnnotationUtils;
import fr.ens.biologie.genomique.eoulsan.annotations.ExecutionMode;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractWorkflow;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.util.Objects;

class StepOutputDirectory {
    private static StepOutputDirectory singleton;
    private final OutputTreeType outputTree;
    private final boolean hadoopMode = EoulsanRuntime.getRuntime().getMode().isHadoopMode();

    public DataFile defaultDirectory(AbstractWorkflow workflow, AbstractStep step, Module module, boolean copyResultsToOutput) {
        Objects.requireNonNull(workflow, "workflow argument cannot be null");
        Objects.requireNonNull(step, "step argument cannot be null");
        Objects.requireNonNull(module, "module argument cannot be null");
        if (this.hadoopMode && ExecutionMode.getExecutionMode(module.getClass()).isHadoopCompatible()) {
            return workflow.getHadoopWorkingDirectory();
        }
        if (copyResultsToOutput) {
            return this.workflowDirectory(workflow, step, module);
        }
        return this.workingDirectory(workflow, step, module);
    }

    public DataFile workingDirectory(AbstractWorkflow workflow, AbstractStep step, Module module) {
        Objects.requireNonNull(workflow, "workflow argument cannot be null");
        Objects.requireNonNull(step, "step argument cannot be null");
        Objects.requireNonNull(module, "module argument cannot be null");
        if (this.hadoopMode && ExecutionMode.getExecutionMode(module.getClass()).isHadoopCompatible()) {
            return workflow.getHadoopWorkingDirectory();
        }
        return workflow.getLocalWorkingDirectory();
    }

    public DataFile workflowDirectory(AbstractWorkflow workflow, AbstractStep step, Module module) {
        Objects.requireNonNull(workflow, "workflow argument cannot be null");
        Objects.requireNonNull(step, "step argument cannot be null");
        Objects.requireNonNull(module, "module argument cannot be null");
        if (EoulsanAnnotationUtils.isNoOutputDirectory(module)) {
            return workflow.getOutputDirectory();
        }
        switch (this.outputTree) {
            case STEP: {
                String subDirname = step.getId() + "_output";
                return new DataFile(workflow.getOutputDirectory(), subDirname);
            }
        }
        return workflow.getOutputDirectory();
    }

    public static synchronized StepOutputDirectory getInstance() {
        if (singleton == null) {
            singleton = new StepOutputDirectory();
        }
        return singleton;
    }

    private StepOutputDirectory() {
        this.outputTree = OutputTreeType.getOutputTreeType();
    }

    public static enum OutputTreeType {
        FLAT,
        STEP;


        public static OutputTreeType getOutputTreeType(String type) {
            if (type == null) {
                return OutputTreeType.valueOf("step");
            }
            OutputTreeType result = OutputTreeType.valueOf(type.toUpperCase().trim());
            if (result == null) {
                return OutputTreeType.valueOf("step");
            }
            return result;
        }

        public static OutputTreeType getOutputTreeType() {
            return OutputTreeType.getOutputTreeType(EoulsanRuntime.getSettings().getOutputTreeType());
        }
    }
}

