/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.SimpleOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataElement;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowFileNaming;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class StepOutputPort
extends SimpleOutputPort {
    private static final long serialVersionUID = -7857426034202971843L;
    private final AbstractStep step;
    private final Set<StepInputPort> links = new HashSet<StepInputPort>();

    public AbstractStep getStep() {
        return this.step;
    }

    public Set<StepInputPort> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public boolean isLinked() {
        return this.links.size() > 0;
    }

    public void addLink(StepInputPort inputPort) {
        Objects.requireNonNull(inputPort, "inputPort argument cannot be null");
        Preconditions.checkArgument((inputPort.getStep() != this.step ? 1 : 0) != 0, (Object)("cannot link a step (" + this.step.getId() + ") to itself (input port: " + inputPort.getName() + ", output port: " + this.getName()));
        if (this.links.contains(inputPort)) {
            return;
        }
        if (!this.getFormat().equals(inputPort.getFormat())) {
            throw new EoulsanRuntimeException("Incompatible format: " + inputPort.getStep().getId() + "." + inputPort.getName() + " -> " + inputPort.getFormat().getName() + " and " + this.getStep().getId() + "." + this.getName() + " <- " + this.getFormat().getName());
        }
        this.links.add(inputPort);
    }

    public List<DataFile> getExistingOutputFiles() {
        ArrayList<DataFile> result = new ArrayList<DataFile>();
        try {
            List<DataFile> dirFiles = this.step.getStepOutputDirectory().list();
            String filePrefix = WorkflowFileNaming.filePrefix(this);
            String fileSuffix = WorkflowFileNaming.fileSuffix(this);
            for (DataFile f : dirFiles) {
                if (!FileNaming.isFilenameValid(f) || !f.getName().startsWith(filePrefix) || !f.getName().endsWith(fileSuffix)) continue;
                result.add(f);
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public Set<Data> getExistingData() {
        ArrayList files = Lists.newArrayList(this.getExistingOutputFiles());
        if (files.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Data> result = new HashSet<Data>();
        Collections.sort(files);
        ArrayListMultimap map = ArrayListMultimap.create();
        for (DataFile file : files) {
            FileNaming fields = FileNaming.parse(file);
            map.put((Object)(fields.getDataName() + "\t" + fields.getPart()), (Object)file);
        }
        Design design = this.step.getAbstractWorkflow().getDesign();
        for (String key : map.keySet()) {
            DataElement data = new DataElement(this.getFormat(), map.get((Object)key), design);
            data.setName(key.substring(0, key.indexOf(9)));
            result.add(data);
        }
        return result;
    }

    public boolean isAllLinksToSkippedSteps() {
        for (StepInputPort inPort : this.getLinks()) {
            if (inPort.getStep().isSkip()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Step> getLinkedSteps() {
        if (this.links.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AbstractStep> result = new HashSet<AbstractStep>();
        for (StepInputPort inputPort : this.links) {
            result.add(inputPort.getStep());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("format", (Object)this.getFormat().getName()).add("compression", (Object)this.getCompression()).add("step", (Object)this.getStep().getId()).toString();
    }

    public StepOutputPort(AbstractStep step, String name, boolean list, DataFormat format, CompressionType compression) {
        super(name, list, format, compression);
        if (step == null) {
            throw new NullPointerException("Step is null");
        }
        this.step = step;
    }
}

