/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Joiner;
import com.google.common.eventbus.Subscribe;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStateEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TokenManagerRegistry;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StepStateDependencies
implements Serializable {
    private static final long serialVersionUID = 3290646225243643382L;
    private final AbstractStep step;
    private volatile Step.StepState stepState = Step.StepState.CREATED;
    private volatile boolean noInput = false;
    private final Set<AbstractStep> requiredSteps = new HashSet<AbstractStep>();
    private final Map<Integer, Boolean> dependenciesDone = new HashMap<Integer, Boolean>();

    public void addDependency(AbstractStep step) {
        this.requiredSteps.add(step);
        WorkflowEventBus.getInstance().register(step.getStepStateDependencies());
        if (!this.dependenciesDone.containsKey(step.getNumber())) {
            this.dependenciesDone.put(step.getNumber(), false);
        }
    }

    public Set<AbstractStep> getRequiredSteps() {
        return Collections.unmodifiableSet(this.requiredSteps);
    }

    public Step.StepState getState() {
        return this.stepState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void stepStateEvent(StepStateEvent event) {
        if (event == null) {
            return;
        }
        int eventStepNumber = event.getStep().getNumber();
        Step.StepState state = event.getState();
        if (eventStepNumber == this.step.getNumber()) {
            this.setState(state);
            return;
        }
        if (this.stepState == Step.StepState.WAITING && this.isDepencenyStepDone(state) && this.dependenciesDone.containsKey(eventStepNumber)) {
            Map<Integer, Boolean> map = this.dependenciesDone;
            synchronized (map) {
                if (this.dependenciesDone.get(eventStepNumber).booleanValue()) {
                    return;
                }
                this.dependenciesDone.put(eventStepNumber, true);
                for (boolean done : this.dependenciesDone.values()) {
                    if (done) continue;
                    return;
                }
                this.setState(Step.StepState.READY);
            }
        }
    }

    private boolean isDepencenyStepDone(Step.StepState state) {
        return this.noInput ? state == Step.StepState.DONE : state.isDoneState();
    }

    private synchronized void setState(Step.StepState state) {
        if (state == null || state == Step.StepState.CREATED || this.stepState == state || this.stepState.isFinalState()) {
            return;
        }
        if (state == Step.StepState.READY && this.stepState.isWorkingState()) {
            return;
        }
        Step.StepState previousState = this.stepState;
        if (state == Step.StepState.CONFIGURED) {
            this.noInput = this.step.getInputPorts().isEmpty();
        }
        this.stepState = this.step.getType() == Step.StepType.ROOT_STEP && state == Step.StepState.WAITING ? Step.StepState.READY : state;
        EoulsanLogger.getLogger().fine("Step #" + this.step.getNumber() + " " + this.step.getId() + " is now in state " + this.stepState + " (previous state was " + previousState + ")");
        if (this.stepState == Step.StepState.WAITING) {
            this.logDependencies();
        }
        if (this.stepState == Step.StepState.READY) {
            TokenManagerRegistry.getInstance().getTokenManager(this.step).start();
        }
    }

    void logDependencies() {
        String msg = "Step #" + this.step.getNumber() + " " + this.step.getId() + " has the following dependencies: ";
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (AbstractStep step : this.requiredSteps) {
            list.add((CallSite)((Object)("step #" + step.getNumber() + " " + step.getId())));
        }
        msg = list.isEmpty() ? msg + "no dependencies" : msg + Joiner.on((String)", ").join(list);
        EoulsanLogger.getLogger().fine(msg);
    }

    public StepStateDependencies(AbstractStep step) {
        Objects.requireNonNull(step, "step cannot be null");
        this.step = step;
        WorkflowEventBus.getInstance().register(this);
        EoulsanLogger.getLogger().fine("Step #" + this.step.getNumber() + " " + this.step.getId() + " is now in state " + this.stepState);
    }
}

