/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TokenManagerRegistry;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UIStepEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UITaskEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StepStatus {
    private final AbstractStep step;
    private final Map<Integer, Double> taskProgress = new HashMap<Integer, Double>();
    private final Map<Integer, String> taskNames = new HashMap<Integer, String>();
    private double progress = Double.NaN;
    private String note;

    public String getNote() {
        return this.note;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProgress() {
        if (Double.isNaN(this.progress)) {
            double sum = 0.0;
            StepStatus stepStatus = this;
            synchronized (stepStatus) {
                for (Double p : this.taskProgress.values()) {
                    sum += p.doubleValue();
                }
            }
            return sum / (double)TokenManagerRegistry.getInstance().getTokenManager(this.step).getContextCount();
        }
        return this.progress;
    }

    public String getTaskName(int contextId) {
        return this.taskNames.get(contextId);
    }

    public double getTaskProgress(int contextId) {
        return this.taskProgress.get(contextId);
    }

    public int getSubmittedTasks() {
        return this.taskProgress.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTerminatedTasks() {
        int result = 0;
        StepStatus stepStatus = this;
        synchronized (stepStatus) {
            for (double progress : this.taskProgress.values()) {
                if (progress != 1.0) continue;
                ++result;
            }
        }
        return result;
    }

    public void setNote(String note) {
        this.note = note;
        this.noteStatusUpdated();
    }

    public void setProgress(int min, int max, int value) {
        StepStatus.checkProgress(min, max, value);
        if (min == max) {
            this.setProgress(1.0);
        } else {
            this.setProgress((double)(value - min) / (double)(max - min));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(double progress) {
        StepStatus.checkProgress(progress);
        StepStatus stepStatus = this;
        synchronized (stepStatus) {
            this.progress = progress;
        }
        this.progressStatusUpdated();
    }

    public void setTaskProgress(int contextId, String contextName, int min, int max, int value) {
        StepStatus.checkProgress(min, max, value);
        if (min == max) {
            this.setTaskProgress(contextId, contextName, 1.0);
        } else {
            this.setTaskProgress(contextId, contextName, (double)(value - min) / (double)(max - min));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskProgress(int contextId, String contextName, double progress) {
        StepStatus.checkContext(contextId, contextName);
        StepStatus.checkProgress(progress);
        this.progressTaskStatusUpdated(contextId, contextName, progress);
        StepStatus stepStatus = this;
        synchronized (stepStatus) {
            this.taskProgress.put(contextId, progress);
            if (!this.taskNames.containsKey(contextId) || !this.taskNames.get(contextId).equals(contextName)) {
                this.taskNames.put(contextId, contextName);
            }
        }
        this.progressStatusUpdated();
    }

    public void setTaskSubmitted(int contextId) {
        WorkflowEventBus.getInstance().postUIEvent(new UITaskEvent(this.step, UITaskEvent.TaskStatusMessage.SUBMITTED, contextId));
    }

    public void setTaskRunning(int contextId) {
        WorkflowEventBus.getInstance().postUIEvent(new UITaskEvent(this.step, UITaskEvent.TaskStatusMessage.RUNNING, contextId));
    }

    public void setTaskDone(int contextId) {
        WorkflowEventBus.getInstance().postUIEvent(new UITaskEvent(this.step, UITaskEvent.TaskStatusMessage.DONE, contextId));
    }

    private void progressTaskStatusUpdated(int contextId, String contextName, double progress) {
        WorkflowEventBus.getInstance().postUIEvent(new UIStepEvent((Step)this.step, contextId, contextName, progress));
    }

    private void progressStatusUpdated() {
        WorkflowEventBus.getInstance().postUIEvent(new UIStepEvent((Step)this.step, this.getTerminatedTasks(), this.getSubmittedTasks(), this.getProgress()));
    }

    private void noteStatusUpdated() {
        WorkflowEventBus.getInstance().postUIEvent(new UIStepEvent(this.step, this.note));
    }

    private static void checkContext(int contextId, String contextName) {
        Objects.requireNonNull(contextName, "contextName cannot be null");
    }

    private static void checkProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 ? 1 : 0) != 0, (Object)("Progress is lower than 0: " + progress));
        Preconditions.checkArgument((progress <= 1.0 ? 1 : 0) != 0, (Object)("Progress is greater than 1: " + progress));
        Preconditions.checkArgument((!Double.isInfinite(progress) ? 1 : 0) != 0, (Object)"Progress is infinite");
        Preconditions.checkArgument((!Double.isNaN(progress) ? 1 : 0) != 0, (Object)"Progress is NaN");
    }

    private static void checkProgress(int min, int max, int value) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"Max is lower than min");
        Preconditions.checkArgument((min <= value ? 1 : 0) != 0, (Object)"Value is lower than min");
        Preconditions.checkArgument((value <= max ? 1 : 0) != 0, (Object)"Value is greater than max");
    }

    public StepStatus(AbstractStep step) {
        Objects.requireNonNull(step, "Step is null");
        this.step = step;
    }
}

