/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.annotations.EoulsanAnnotationUtils;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractData;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ModuleRegistry;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepConfigurationContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInstances;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskResultImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskStatusImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TokenManagerRegistry;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UnmodifiableData;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowDataUtils;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class TaskRunner {
    private final TaskContextImpl context;
    private final Module module;
    private final TaskStatusImpl status;
    private volatile TaskResult result;
    private boolean isTokensSent;
    private boolean forceStepInstanceReuse;

    public TaskResultImpl getResult() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"The context has not been run");
        return (TaskResultImpl)this.result;
    }

    public void setForceStepInstanceReuse(boolean reuse) {
        this.forceStepInstanceReuse = reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResultImpl run() {
        Logger logger;
        Preconditions.checkState((this.result == null ? 1 : 0) != 0, (Object)"task has been already executed");
        String threadGroupName = "TaskRunner_" + this.context.getStep().getId() + "_#" + this.context.getId();
        ThreadGroup threadGroup = new ThreadGroup(threadGroupName);
        Logger logger2 = logger = EoulsanAnnotationUtils.isNoLog(this.module) ? null : this.createStepLogger(this.context.getStep(), threadGroupName);
        if (logger != null) {
            EoulsanLogger.registerThreadGroupLogger(threadGroup, logger);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                EoulsanLogger.getLogger().info("Start of task #" + TaskRunner.this.context.getId());
                long startTime = System.currentTimeMillis();
                Step.StepType stepType = TaskRunner.this.context.getWorkflowStep().getType();
                boolean reuseAnnot = EoulsanAnnotationUtils.isReuseStepInstance(TaskRunner.this.module);
                String stepDescLog = String.format("step (id: %s, name: %s, class: %s) for task #%d", TaskRunner.this.context.getWorkflowStep().getId(), TaskRunner.this.module.getName(), TaskRunner.this.module.getClass().getName(), TaskRunner.this.context.getId());
                try {
                    Module module;
                    if (stepType == Step.StepType.STANDARD_STEP && !reuseAnnot && !TaskRunner.this.forceStepInstanceReuse) {
                        EoulsanLogger.getLogger().fine("Create new instance of " + stepDescLog);
                        String stepName = TaskRunner.this.module.getName();
                        Version stepVersion = TaskRunner.this.module.getVersion();
                        module = ModuleRegistry.getInstance().loadModule(stepName, stepVersion.toString());
                        this.logStepParameters();
                        EoulsanLogger.getLogger().fine("Configure step instance");
                        module.configure(new StepConfigurationContextImpl(TaskRunner.this.context.getStep()), TaskRunner.this.context.getCurrentStep().getParameters());
                    } else {
                        EoulsanLogger.getLogger().fine("Reuse original instance of " + stepDescLog);
                        module = TaskRunner.this.module;
                        this.logStepParameters();
                    }
                    EoulsanLogger.getLogger().info("Execute task");
                    TaskRunner.this.result = module.execute(TaskRunner.this.context, TaskRunner.this.status);
                }
                catch (Throwable t) {
                    EoulsanLogger.getLogger().severe("Exception while executing task: " + t.getMessage());
                    TaskRunner.this.result = TaskRunner.this.status.createTaskResult(t);
                }
                long duration = System.currentTimeMillis() - startTime;
                TaskResult result = TaskRunner.this.result;
                boolean success = result.isSuccess();
                EoulsanLogger.getLogger().info("End of task #" + TaskRunner.this.context.getId());
                EoulsanLogger.getLogger().info("Duration: " + StringUtils.toTimeHumanReadable((long)duration));
                EoulsanLogger.getLogger().info("Result: " + (success ? "Success" : "Fail"));
                if (!success) {
                    String errorMessage = result.getErrorMessage();
                    Throwable exception = result.getException();
                    if (errorMessage != null) {
                        EoulsanLogger.getLogger().severe("Error message: " + errorMessage);
                    }
                    if (exception != null) {
                        EoulsanLogger.getLogger().severe("Exception: " + StringUtils.stackTraceToString((Throwable)exception));
                    }
                }
            }

            private void logStepParameters() {
                Set<Parameter> parameters = TaskRunner.this.context.getCurrentStep().getParameters();
                if (parameters.isEmpty()) {
                    EoulsanLogger.getLogger().fine("Step has no parameter");
                } else {
                    for (Parameter p : parameters) {
                        EoulsanLogger.getLogger().fine("Step parameter: " + p.getName() + "=" + p.getValue());
                    }
                }
            }
        };
        this.status.setProgress(0.0);
        this.status.durationStart();
        try {
            Thread thread = new Thread(threadGroup, r, threadGroupName);
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            EoulsanLogger.getLogger().severe((String)(e.getMessage() == null ? "Interruption of the thread " + threadGroupName : e.getMessage()));
            TokenManagerRegistry.getInstance().getTokenManager(this.context.getStep()).addFailedOutputData(this.context);
        }
        finally {
            Handler[] handlers;
            if (logger != null && (handlers = logger.getHandlers()) != null && handlers.length > 0) {
                Handler handler = handlers[0];
                handler.close();
                EoulsanLogger.removeThreadGroupLogger(threadGroup);
                logger.removeHandler(handler);
            }
        }
        if (this.result == null) {
            this.result = this.status.createTaskResult(new EoulsanException("The step " + this.context.getStep().getId() + " has not generate a result object"));
        }
        this.sendTokens();
        return (TaskResultImpl)this.result;
    }

    private void sendTokens() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Cannot send tokens of a null result task");
        Preconditions.checkState((!this.isTokensSent ? 1 : 0) != 0, (Object)"Cannot send tokens twice");
        this.isTokensSent = true;
        if (!this.result.isSuccess()) {
            return;
        }
        for (String portName : this.context.getCurrentStep().getOutputPorts().getPortNames()) {
            StepOutputPort port = (StepOutputPort)this.context.getStep().getWorkflowOutputPorts().getPort(portName);
            Data data = this.context.getOutputData(port);
            WorkflowEventBus.getInstance().postToken(port, data);
        }
        AbstractStep step = this.context.getWorkflowStep();
        if (step.getState() == Step.StepState.WORKING) {
            WorkflowEventBus.getInstance().postStepStateChange(step, Step.StepState.PARTIALLY_DONE);
        }
    }

    private String createDefaultContextName() {
        LinkedHashSet<String> namedData = new LinkedHashSet<String>();
        LinkedHashSet<String> defaultNamedData = new LinkedHashSet<String>();
        LinkedHashSet<String> fileNames = new LinkedHashSet<String>();
        LinkedHashSet<String> otherDataNames = new LinkedHashSet<String>();
        for (String inputPortName : this.context.getCurrentStep().getInputPorts().getPortNames()) {
            AbstractData data = ((UnmodifiableData)this.context.getInputData(inputPortName)).getData();
            if (!data.isList()) {
                if (!data.isDefaultName()) {
                    namedData.add(data.getName());
                    continue;
                }
                if (data.isNameSet()) {
                    defaultNamedData.add(data.getName());
                    continue;
                }
                for (DataFile file : WorkflowDataUtils.getDataFiles(data)) {
                    fileNames.add(file.getName());
                }
                continue;
            }
            otherDataNames.add(data.getName());
        }
        if (!namedData.isEmpty()) {
            return Joiner.on((char)'-').join(namedData);
        }
        if (!defaultNamedData.isEmpty()) {
            return Joiner.on((char)'-').join(defaultNamedData);
        }
        if (!fileNames.isEmpty()) {
            return Joiner.on((char)'-').join(fileNames);
        }
        return Joiner.on((char)'-').join(otherDataNames);
    }

    private Logger createStepLogger(AbstractStep step, String threadGroupName) {
        OutputStream logOut;
        DataFile logDir = this.context.getStep().getAbstractWorkflow().getTaskDirectory();
        DataFile logFile = new DataFile(logDir, this.context.getTaskFilePrefix() + ".task.log");
        try {
            logOut = logFile.create();
        }
        catch (IOException e) {
            return null;
        }
        Logger logger = Logger.getLogger(threadGroupName);
        StreamHandler handler = new StreamHandler(logOut, Globals.LOG_FORMATTER);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.ALL);
        logger.addHandler(handler);
        String logLevel = Main.getInstance().getLogLevelArgument();
        if (logLevel == null) {
            logLevel = Globals.LOG_LEVEL.getName();
        }
        handler.setLevel(Level.parse(logLevel.toUpperCase()));
        return logger;
    }

    public static TaskResultImpl createStepResult(TaskContextImpl taskContext, Throwable exception) {
        return TaskRunner.createStepResult(taskContext, exception, exception != null ? exception.getMessage() : null);
    }

    public static TaskResultImpl createStepResult(TaskContextImpl taskContext, Throwable exception, String errorMessage) {
        TaskRunner runner = new TaskRunner(taskContext);
        runner.status.durationStart();
        return (TaskResultImpl)runner.status.createTaskResult(exception, errorMessage);
    }

    public static void sendTokens(TaskContextImpl taskContext, TaskResultImpl taskResult) {
        new TaskRunner(taskContext, taskResult).sendTokens();
    }

    public TaskRunner(TaskContextImpl taskContext) {
        this(taskContext, (StepStatus)null);
    }

    public TaskRunner(TaskContextImpl taskContext, StepStatus stepStatus) {
        Objects.requireNonNull(taskContext, "taskContext cannot be null");
        this.context = taskContext;
        this.module = StepInstances.getInstance().getModule(taskContext.getCurrentStep());
        this.status = new TaskStatusImpl(taskContext, stepStatus);
        this.context.setContextName(this.createDefaultContextName());
    }

    private TaskRunner(TaskContextImpl taskContext, TaskResultImpl taskResult) {
        Objects.requireNonNull(taskContext, "taskContext cannot be null");
        Objects.requireNonNull(taskResult, "taskResult cannot be null");
        Preconditions.checkArgument((taskContext.getId() == taskResult.getContext().getId() ? 1 : 0) != 0, (Object)"");
        this.context = taskContext;
        this.result = taskResult;
        this.module = null;
        this.status = null;
    }
}

