/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskSchedulerFactory;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInstances;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskResultImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskRunner;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;

public class TaskSerializationUtils {
    public static TaskResultImpl execute(DataFile taskContextFile) throws IOException, EoulsanException {
        Objects.requireNonNull(taskContextFile, "contextFile argument cannot be null");
        return TaskSerializationUtils.execute(taskContextFile, taskContextFile.getParent());
    }

    public static TaskResultImpl execute(DataFile taskContextFile, DataFile outputDir) throws IOException, EoulsanException {
        Objects.requireNonNull(taskContextFile, "contextFile argument cannot be null");
        Objects.requireNonNull(outputDir, "taskResultFile argument cannot be null");
        if (!taskContextFile.exists()) {
            throw new FileNotFoundException("The context file does not exists: " + taskContextFile);
        }
        TaskContextImpl context = TaskContextImpl.deserialize(taskContextFile);
        TaskResultImpl result = TaskSerializationUtils.executeContext(context);
        TaskSerializationUtils.saveTaskResult(taskContextFile, context, result);
        return result;
    }

    private static TaskResultImpl executeContext(TaskContextImpl context) throws EoulsanException {
        Module module = StepInstances.getInstance().getModule(context.getCurrentStep());
        long startTime = System.currentTimeMillis();
        try {
            module.configure(context, context.getCurrentStep().getParameters());
        }
        catch (Throwable t) {
            long endTime = System.currentTimeMillis();
            EoulsanLogger.getLogger().severe("Exception while configuring task: " + t.getMessage());
            return new TaskResultImpl(context, new Date(startTime), new Date(endTime), endTime - startTime, t, t.getMessage());
        }
        TaskRunner runner = new TaskRunner(context);
        runner.setForceStepInstanceReuse(true);
        TaskSchedulerFactory.initialize();
        return runner.run();
    }

    private static void saveTaskResult(DataFile taskContextFile, TaskContextImpl context, TaskResultImpl result) throws IOException {
        String taskPrefix = context.getTaskFilePrefix();
        DataFile baseDir = taskContextFile.getParent();
        result.serialize(new DataFile(baseDir, taskPrefix + ".task.result"));
        context.serializeOutputData(new DataFile(baseDir, taskPrefix + ".task.data"));
        new DataFile(baseDir, taskPrefix + ".task.done").create().close();
    }
}

