/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.SerializableStopwatch;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskResultImpl;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TaskStatusImpl
implements TaskStatus {
    private final TaskContextImpl context;
    private final StepStatus status;
    private String message;
    private final Map<String, Long> counters = new HashMap<String, Long>();
    private String taskDescription;
    private String taskCommandLine;
    private double progress;
    private volatile boolean done;
    private Date startDate;
    private Date endDate;
    private final SerializableStopwatch stopwatch = new SerializableStopwatch();

    @Override
    public String getProgressMessage() {
        return this.message;
    }

    @Override
    public Map<String, Long> getCounters() {
        return Collections.unmodifiableMap(this.counters);
    }

    @Override
    public String getDescription() {
        return this.taskDescription;
    }

    @Override
    public String getCommandLine() {
        return this.taskCommandLine;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgressMessage(String message) {
        TaskStatusImpl taskStatusImpl = this;
        synchronized (taskStatusImpl) {
            this.message = message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String description) {
        Objects.requireNonNull(description, "the description argument cannot be null");
        TaskStatusImpl taskStatusImpl = this;
        synchronized (taskStatusImpl) {
            this.taskDescription = description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommandLine(String commandLine) {
        Objects.requireNonNull(commandLine, "the commandLine argument cannot be null");
        TaskStatusImpl taskStatusImpl = this;
        synchronized (taskStatusImpl) {
            this.taskCommandLine = commandLine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCounters(Reporter reporter, String counterGroup) {
        Objects.requireNonNull(reporter, "Reporter is null");
        Objects.requireNonNull(counterGroup, "Counter group is null");
        for (String counterName : reporter.getCounterNames(counterGroup)) {
            Map<String, Long> map = this.counters;
            synchronized (map) {
                this.counters.put(counterName, reporter.getCounterValue(counterGroup, counterName));
            }
        }
    }

    @Override
    public void setProgress(int min, int max, int value) {
        TaskStatusImpl.checkProgress(min, max, value);
        if (min == max) {
            this.setProgress(1.0);
        } else {
            this.setProgress((double)(value - min) / (double)(max - min));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgress(double progress) {
        if (this.done) {
            return;
        }
        TaskStatusImpl.checkProgress(progress);
        TaskStatusImpl taskStatusImpl = this;
        synchronized (taskStatusImpl) {
            this.progress = progress;
            if (this.status != null) {
                this.status.setTaskProgress(this.context.getId(), this.context.getContextName(), progress);
            }
        }
    }

    private long endOfStep() {
        Preconditions.checkState((this.startDate != null ? 1 : 0) != 0, (Object)"stopwatch has been never started");
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
            this.endDate = new Date(System.currentTimeMillis());
            this.setProgress(1.0);
        }
        Preconditions.checkState((this.endDate != null ? 1 : 0) != 0, (Object)"stopwatch has been never stopped");
        return this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    @Override
    public TaskResult createTaskResult() {
        return this.createTaskResult(true);
    }

    @Override
    public TaskResult createTaskResult(boolean success) {
        long duration = this.endOfStep();
        this.done = true;
        return new TaskResultImpl(this.context, this.startDate, this.endDate, duration, this.message, this.taskDescription == null ? "" : this.taskDescription, this.taskCommandLine == null ? "" : this.taskCommandLine, this.counters, success);
    }

    @Override
    public TaskResult createTaskResult(Throwable exception, String exceptionMessage) {
        long duration = this.endOfStep();
        this.done = true;
        return new TaskResultImpl(this.context, this.startDate, this.endDate, duration, exception, exceptionMessage);
    }

    @Override
    public TaskResult createTaskResult(Throwable exception) {
        return this.createTaskResult(exception, exception.getMessage());
    }

    private static void checkProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 ? 1 : 0) != 0, (Object)("Progress is lower than 0: " + progress));
        Preconditions.checkArgument((progress <= 1.0 ? 1 : 0) != 0, (Object)("Progress is greater than 1: " + progress));
        Preconditions.checkArgument((!Double.isInfinite(progress) ? 1 : 0) != 0, (Object)"Progress is infinite");
        Preconditions.checkArgument((!Double.isNaN(progress) ? 1 : 0) != 0, (Object)"Progress is NaN");
    }

    private static void checkProgress(int min, int max, int value) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"Max is lower than min");
        Preconditions.checkArgument((min <= value ? 1 : 0) != 0, (Object)"Value is lower than min");
        Preconditions.checkArgument((value <= max ? 1 : 0) != 0, (Object)"Value is greater than max");
    }

    void durationStart() {
        this.startDate = new Date(System.currentTimeMillis());
        this.stopwatch.start();
    }

    TaskStatusImpl(TaskContextImpl taskContext, StepStatus status) {
        Objects.requireNonNull(taskContext, "context cannot be null");
        this.context = taskContext;
        this.status = status;
    }
}

