/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

class Token {
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private final int id;
    private final StepOutputPort fromPort;
    private final int tokensCount;
    private final Data data;

    public int getId() {
        return this.id;
    }

    public StepOutputPort getOrigin() {
        return this.fromPort;
    }

    public boolean isEndOfStepToken() {
        return this.tokensCount != -1;
    }

    public int getTokenCount() {
        return this.tokensCount;
    }

    public Data getData() {
        if (this.data == null) {
            throw new IllegalStateException();
        }
        return this.data;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("fromPort", (Object)this.fromPort).add("tokensSent", this.tokensCount).add("data", (Object)this.data).toString();
    }

    Token(StepOutputPort fromPort, int tokenCount) {
        Objects.requireNonNull(fromPort);
        this.id = instanceCount.incrementAndGet();
        this.fromPort = fromPort;
        this.tokensCount = tokenCount;
        this.data = null;
    }

    Token(StepOutputPort fromPort, Data data) {
        Objects.requireNonNull(fromPort);
        Objects.requireNonNull(data);
        this.id = instanceCount.incrementAndGet();
        this.fromPort = fromPort;
        this.tokensCount = -1;
        this.data = data;
    }
}

