/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.InputPort;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskSchedulerFactory;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractData;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataElement;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataList;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataMetadataStorage;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPorts;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepResult;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.Token;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TokenManagerRegistry;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowContext;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowDataUtils;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowFileNaming;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TokenManager
implements Runnable {
    private static final int CHECKING_DELAY_MS = 1000;
    private final AbstractStep step;
    private final TaskScheduler scheduler;
    private final StepInputPorts inputPorts;
    private final StepOutputPorts outputPorts;
    private final Set<Integer> receivedTokens = new HashSet<Integer>();
    private final HashMultiset<StepInputPort> receivedPortTokens = HashMultiset.create();
    private final HashMultiset<StepInputPort> expectedPortTokens = HashMultiset.create();
    private int contextCount;
    private final Multimap<InputPort, Data> inputTokens = ArrayListMultimap.create();
    private final Multimap<OutputPort, Data> outputTokens = ArrayListMultimap.create();
    private final Set<InputPort> closedPorts = new HashSet<InputPort>();
    private final Set<ImmutableMap<InputPort, Data>> cartesianProductsUsed = new HashSet<ImmutableMap<InputPort, Data>>();
    private final Set<Data> failedOutputDataToRemove = new HashSet<Data>();
    private volatile boolean endOfStep;
    private boolean isStarted;

    public boolean isNoTokenToReceive() {
        return this.inputPorts.size() == this.closedPorts.size();
    }

    public int getContextCount() {
        return this.inputPorts.size() == 0 ? 1 : this.cartesianProductsUsed.size();
    }

    public boolean isEndOfStep() {
        return this.endOfStep;
    }

    private boolean checkIfAllPortsHasReceivedSomeData() {
        for (StepInputPort port : this.inputPorts) {
            if (!this.inputTokens.get((Object)port).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean checkIfAllListPortsAreClosed() {
        for (StepInputPort port : this.inputPorts) {
            if (!port.isList() || this.closedPorts.contains(port)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSendingToken(StepOutputPort outputPort, Token token) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(outputPort);
        if (!token.isEndOfStepToken()) {
            Data data = token.getData();
            Multimap<OutputPort, Data> multimap = this.outputTokens;
            synchronized (multimap) {
                for (Data e : data.getListElements()) {
                    this.outputTokens.put((Object)outputPort, (Object)e);
                }
            }
            if (EoulsanRuntime.getSettings().getBooleanSetting("debug.compatibility.result.file.links") && this.step.getType() == Step.StepType.STANDARD_STEP) {
                this.createCompatibilityLinkResultFiles(data);
            }
            this.createSymlinksInOutputDirectory(data);
            DataMetadataStorage metadataStorage = DataMetadataStorage.getInstance(this.step.getAbstractWorkflow().getOutputDirectory());
            if (!this.step.isSkip()) {
                metadataStorage.saveMetaData(data);
            }
        }
    }

    private void createCompatibilityLinkResultFiles(Data data) {
        Objects.requireNonNull(data, "data argument cannot be null");
        for (Data e : data.getListElements()) {
            int sampleNumber = e.getMetadata().getSampleNumber();
            if (sampleNumber == -1) continue;
            for (DataFile f : WorkflowDataUtils.getDataFiles(e)) {
                try {
                    DataFile parentDir = f.getParent();
                    if (!parentDir.isLocalFile()) continue;
                    FileNaming name = FileNaming.parse(f.getName());
                    name.setSampleNumber(sampleNumber);
                    DataFile link = new DataFile(parentDir, name.compatibilityFilename());
                    if (link.exists()) continue;
                    f.symlink(link, true);
                }
                catch (IOException exp) {
                    EoulsanLogger.getLogger().warning("Error while creating compatibility link: " + exp.getMessage());
                }
            }
        }
    }

    private void createSymlinksInOutputDirectory(Data data) {
        Objects.requireNonNull(data, "data argument cannot be null");
        DataFile outputDir = this.step.getAbstractWorkflow().getOutputDirectory();
        DataFile workingDir = this.step.getStepOutputDirectory();
        if (this.step.getType() == Step.StepType.DESIGN_STEP || outputDir.equals(workingDir)) {
            return;
        }
        for (Data dataElement : data.getListElements()) {
            for (DataFile file : WorkflowDataUtils.getDataFiles(dataElement)) {
                DataFile link = new DataFile(outputDir, file.getName());
                try {
                    if (link.exists(false)) {
                        if (link.getMetaData().isSymbolicLink()) {
                            link.delete();
                        } else {
                            throw new IOException();
                        }
                    }
                    file.symlink(link, true);
                }
                catch (IOException e) {
                    EoulsanLogger.getLogger().severe("Cannot create symbolic link: " + link);
                }
            }
        }
    }

    @Subscribe
    public void tokenEvent(Token token) {
        Objects.requireNonNull(token);
        StepOutputPort tokenOrigin = token.getOrigin();
        AbstractStep stepOrigin = tokenOrigin.getStep();
        int currentStepNumber = this.step.getNumber();
        for (StepInputPort linkInputPort : tokenOrigin.getLinks()) {
            if (linkInputPort.getStep().getNumber() != currentStepNumber) continue;
            for (StepInputPort sip : this.inputPorts) {
                if (!sip.getName().equals(linkInputPort.getName())) continue;
                this.postToken(linkInputPort, token);
            }
        }
        if (this.step.getNumber() == stepOrigin.getNumber()) {
            this.logSendingToken(tokenOrigin, token);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToken(StepInputPort inputPort, Token token) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(inputPort);
        Step.StepState originStepState = token.getOrigin().getStep().getState();
        Preconditions.checkState((originStepState.isWorkingState() || originStepState == Step.StepState.DONE ? 1 : 0) != 0, (Object)("Invalid token step origin state: " + originStepState));
        Preconditions.checkState((!this.receivedTokens.contains(token.getId()) ? 1 : 0) != 0, (Object)("Token has been already received: " + token.getId()));
        Preconditions.checkState((boolean)this.inputPorts.contains(inputPort), (Object)("Unknown port: " + inputPort));
        Preconditions.checkState((inputPort.getLink() == token.getOrigin() ? 1 : 0) != 0, (Object)("The input port (" + inputPort + ") and the output port (" + token.getOrigin() + ") are not linked:"));
        Preconditions.checkState((!this.closedPorts.contains(inputPort) || this.step.isSkip() ? 1 : 0) != 0, (Object)("The input port is closed for the step " + this.step.getId() + ": " + inputPort.getName()));
        Set<Integer> set = this.receivedTokens;
        synchronized (set) {
            this.receivedTokens.add(token.getId());
        }
        if (token.isEndOfStepToken()) {
            Preconditions.checkState((token.getTokenCount() > -1 ? 1 : 0) != 0, (Object)"the number of expected token is not set");
            Preconditions.checkState((this.expectedPortTokens.count((Object)inputPort) == 0 ? 1 : 0) != 0, (Object)"the number of expected token has been already set");
            set = this.expectedPortTokens;
            synchronized (set) {
                this.expectedPortTokens.setCount((Object)inputPort, token.getTokenCount());
            }
        }
        set = this.receivedPortTokens;
        synchronized (set) {
            this.receivedPortTokens.add((Object)inputPort);
        }
        Data data = token.getData();
        Set<ImmutableMap<InputPort, Data>> set2 = this.cartesianProductsUsed;
        synchronized (set2) {
            if (data.isList()) {
                for (Data e : data.getListElements()) {
                    this.addData(inputPort, e);
                }
            } else {
                this.addData(inputPort, data);
            }
        }
        if (this.step.isSkip() || this.expectedPortTokens.contains((Object)inputPort) && this.receivedPortTokens.count((Object)inputPort) == this.expectedPortTokens.count((Object)inputPort)) {
            Preconditions.checkState((this.step.isSkip() || !this.inputTokens.get((Object)inputPort).isEmpty() ? 1 : 0) != 0, (Object)("No data receive for port on step " + this.step.getId() + ": " + inputPort.getName()));
            this.closedPorts.add(inputPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addData(StepInputPort inputPort, Data data) {
        if (!inputPort.isList()) {
            Multimap<InputPort, Data> multimap = this.inputTokens;
            synchronized (multimap) {
                this.inputTokens.put((Object)inputPort, (Object)data);
            }
        }
        Collection inputData = this.inputTokens.get((Object)inputPort);
        Design design = this.step.getAbstractWorkflow().getDesign();
        Collection collection = inputData;
        synchronized (collection) {
            DataList dataList;
            if (inputData.isEmpty()) {
                dataList = new DataList(inputPort, design);
                inputData.add(dataList);
            } else {
                dataList = (DataList)inputData.iterator().next();
            }
            dataList.getModifiableList().add(data);
        }
    }

    private void sendEndOfStepTokens() {
        for (StepOutputPort outputPort : this.outputPorts) {
            WorkflowEventBus.getInstance().postToken(outputPort, this.contextCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSkipStepTokens() {
        HashMap<String, Sample> samples = new HashMap<String, Sample>();
        for (Sample sample : this.step.getWorkflow().getDesign().getSamples()) {
            samples.put(Naming.toValidName(sample.getId()), sample);
        }
        int maxExistingDataCount = 0;
        for (StepOutputPort port : this.outputPorts) {
            if (port.getLinks().isEmpty() || port.isAllLinksToSkippedSteps()) continue;
            Set<Data> existingData = port.getExistingData();
            maxExistingDataCount = Math.max(maxExistingDataCount, existingData.size());
            if (existingData.size() == 0) {
                throw new EoulsanRuntimeException("No output files of the step \"" + this.step.getId() + "\" matching with " + WorkflowFileNaming.glob(port) + " found");
            }
            for (Data data : existingData) {
                DataMetadataStorage metadataStorage = DataMetadataStorage.getInstance(this.step.getAbstractWorkflow().getOutputDirectory());
                boolean isMetadataSet = metadataStorage.loadMetadata(data);
                if (!isMetadataSet && samples.containsKey(data.getName())) {
                    WorkflowDataUtils.setDataMetaData(data, (Sample)samples.get(data.getName()));
                }
                WorkflowEventBus.getInstance().postToken(port, data);
            }
        }
        TokenManager tokenManager = this;
        synchronized (tokenManager) {
            this.contextCount = maxExistingDataCount;
        }
        this.sendEndOfStepTokens();
    }

    private Map<OutputPort, AbstractData> createContextOutputData() {
        Design design = this.step.getAbstractWorkflow().getDesign();
        HashMap<OutputPort, AbstractData> result = new HashMap<OutputPort, AbstractData>();
        for (StepOutputPort outputPort : this.outputPorts) {
            AbstractData data = outputPort.isList() ? new DataList(outputPort, design) : new DataElement(outputPort, design);
            result.put(outputPort, data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TaskContextImpl> createContexts(WorkflowContext workflowContext) {
        Set<Object> cartesianProductToProcess;
        HashSet<TaskContextImpl> result = new HashSet<TaskContextImpl>();
        Set<ImmutableMap<InputPort, Data>> set = this.cartesianProductsUsed;
        synchronized (set) {
            cartesianProductToProcess = !this.checkIfAllPortsHasReceivedSomeData() || !this.checkIfAllListPortsAreClosed() ? Collections.emptySet() : this.step.getDataProduct().makeProduct(this.inputPorts, this.inputTokens);
            cartesianProductToProcess.removeAll(this.cartesianProductsUsed);
            this.cartesianProductsUsed.addAll(cartesianProductToProcess);
        }
        for (Map map : cartesianProductToProcess) {
            Map<OutputPort, AbstractData> outputData = this.createContextOutputData();
            result.add(new TaskContextImpl(workflowContext, this.step, map, outputData));
        }
        return result;
    }

    private Set<TaskContextImpl> createContextWhenNoInputPortExist(WorkflowContext workflowContext) {
        Map<InputPort, Data> inputData = Collections.emptyMap();
        Map<OutputPort, AbstractData> outputData = this.createContextOutputData();
        return Collections.singleton(new TaskContextImpl(workflowContext, this.step, inputData, outputData));
    }

    private void writeStepResult(StepResult result) {
        if (result == null) {
            return;
        }
        DataFile logFile = new DataFile(this.step.getAbstractWorkflow().getJobDirectory(), this.step.getId() + ".step.result");
        try {
            result.write(logFile, false);
        }
        catch (IOException e) {
            Common.showAndLogErrorMessage("Unable to create log file for " + this.step.getId() + " step.");
        }
        if (EoulsanRuntime.getSettings().isUseOldEoulsanResultFormat()) {
            logFile = new DataFile(this.step.getAbstractWorkflow().getJobDirectory(), this.step.getId() + ".log");
            try {
                result.write(logFile, true);
            }
            catch (IOException e) {
                Common.showAndLogErrorMessage("Unable to create log file for " + this.step.getId() + " step.");
            }
        }
    }

    private void removeInputsIfRequired() {
        TokenManagerRegistry registry = TokenManagerRegistry.getInstance();
        for (AbstractStep step : this.step.getWorkflowInputPorts().getLinkedSteps()) {
            TokenManager tokenManager = registry.getTokenManager(step);
            tokenManager.removeOutputsIfRequired();
        }
    }

    private void removeOutputsIfRequired() {
        if (this.step.getDiscardOutput() != Step.DiscardOutput.ASAP) {
            return;
        }
        for (AbstractStep step : this.step.getWorkflowOutputPorts().getLinkedSteps()) {
            if (step.getState() == Step.StepState.DONE) continue;
            return;
        }
        this.removeOutputsToDiscard();
    }

    void addFailedOutputData(TaskContextImpl failedContext) {
        Objects.requireNonNull(failedContext, "failedContext cannot be null");
        for (OutputPort port : this.outputPorts) {
            this.failedOutputDataToRemove.add(failedContext.getOutputData(port));
        }
    }

    void removeOutputsToDiscard() {
        boolean remove;
        if (this.step.getType() != Step.StepType.STANDARD_STEP) {
            return;
        }
        DataFile outputWorkflowDir = this.step.getAbstractWorkflow().getOutputDirectory();
        boolean bl = remove = this.step.getDiscardOutput() != Step.DiscardOutput.NO;
        if (!remove && EoulsanRuntime.getSettings().getBooleanSetting("debug.keep.step.output.links")) {
            return;
        }
        for (Data entry : this.outputTokens.values()) {
            for (Data data : entry.getListElements()) {
                if (data.getFormat().getMaxFilesCount() < 2) {
                    if (remove) {
                        this.removeFileAndSymLink(data.getDataFile(), outputWorkflowDir);
                        continue;
                    }
                    this.removeSymLink(data.getDataFile(), outputWorkflowDir);
                    continue;
                }
                for (int i = 0; i < data.getDataFileCount(); ++i) {
                    if (remove) {
                        this.removeFileAndSymLink(data.getDataFile(i), outputWorkflowDir);
                        continue;
                    }
                    this.removeSymLink(data.getDataFile(i), outputWorkflowDir);
                }
            }
        }
    }

    void removeAllOutputs() {
        if (this.step.getType() != Step.StepType.STANDARD_STEP && this.step.getType() != Step.StepType.GENERATOR_STEP) {
            return;
        }
        DataFile outputWorkflowDir = this.step.getAbstractWorkflow().getOutputDirectory();
        ArrayList<Data> list = new ArrayList<Data>();
        list.addAll(this.outputTokens.values());
        list.addAll(this.failedOutputDataToRemove);
        for (Data entry : list) {
            for (Data data : entry.getListElements()) {
                if (data.getFormat().getMaxFilesCount() < 2) {
                    this.removeFileAndSymLink(data.getDataFile(), outputWorkflowDir);
                    continue;
                }
                for (int i = 0; i < data.getDataFileCount(); ++i) {
                    this.removeFileAndSymLink(data.getDataFile(i), outputWorkflowDir);
                }
            }
        }
    }

    private void removeFileAndSymLink(DataFile file, DataFile symlinkDir) {
        EoulsanLogger.getLogger().fine("Remove output file: " + file);
        try {
            if ("hdfs".equals(file.getProtocol().getName())) {
                file.delete(true);
            } else {
                file.delete();
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Cannot remove data to discard: " + file + " (" + e.getMessage() + ")");
        }
        this.removeSymLink(file, symlinkDir);
    }

    private void removeSymLink(DataFile file, DataFile symlinkDir) {
        DataFile link = new DataFile(symlinkDir, file.getName());
        try {
            if (link.exists(false) && link.getMetaData().isSymbolicLink()) {
                EoulsanLogger.getLogger().fine("Remove symbolic link: " + link);
                link.delete();
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Cannot remove data symbolic link to discard: " + link + " (" + e.getMessage() + ")");
        }
    }

    void start() {
        if (EoulsanRuntime.getRuntime().getMode() == AbstractEoulsanRuntime.EoulsanExecMode.CLUSTER_TASK) {
            return;
        }
        Preconditions.checkState((!this.isStarted ? 1 : 0) != 0, (Object)("The token manager thread for step " + this.step.getId() + " is already started"));
        new Thread((Runnable)this, "TokenManager_" + this.step.getId()).start();
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    void stop() {
        Preconditions.checkState((boolean)this.isStarted, (Object)("The token manager thread for step " + this.step.getId() + " is not started"));
        this.isStarted = false;
        this.endOfStep = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean firstSubmission = true;
            WorkflowEventBus eventBus = WorkflowEventBus.getInstance();
            do {
                Set<TaskContextImpl> contexts;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    EoulsanLogger.getLogger().severe(e.getMessage());
                }
                Step.StepState state = this.step.getState();
                if (state != Step.StepState.READY && !state.isWorkingState()) continue;
                if (state == Step.StepState.READY) {
                    eventBus.postStepStateChange(this.step, Step.StepState.WORKING);
                }
                TokenManager tokenManager = this;
                synchronized (tokenManager) {
                    WorkflowContext workflowContext = this.step.getAbstractWorkflow().getWorkflowContext();
                    contexts = this.inputPorts.size() > 0 ? this.createContexts(workflowContext) : this.createContextWhenNoInputPortExist(workflowContext);
                }
                tokenManager = this;
                synchronized (tokenManager) {
                    this.contextCount += contexts.size();
                }
                if (!this.step.isSkip()) {
                    if (firstSubmission) {
                        DataFile outputDirectory = this.step.getStepOutputDirectory();
                        if (!outputDirectory.exists()) {
                            outputDirectory.mkdirs();
                        }
                        firstSubmission = false;
                    }
                    this.scheduler.submit((Step)this.step, contexts);
                }
                if (!this.isNoTokenToReceive()) continue;
                this.logReceivedTokens();
                if (!this.step.isSkip()) {
                    this.scheduler.waitEndOfTasks(this.step);
                    if (this.step.getState() != Step.StepState.ABORTED) {
                        StepResult result = this.scheduler.getResult(this.step);
                        result.setImmutable();
                        if (result.isSuccess()) {
                            eventBus.postStepStateChange(this.step, Step.StepState.DONE);
                            if (this.step.isCreateLogFiles()) {
                                this.writeStepResult(result);
                            }
                            this.sendEndOfStepTokens();
                        }
                    }
                } else {
                    eventBus.postStepStateChange(this.step, Step.StepState.DONE);
                    this.sendSkipStepTokens();
                }
                this.logSentTokens();
                this.endOfStep = true;
            } while (!this.endOfStep);
        }
        catch (Throwable exception) {
            this.step.getAbstractWorkflow().emergencyStop(exception, "Error while executing the workflow");
        }
        WorkflowEventBus.getInstance().register(this);
        this.removeInputsIfRequired();
    }

    private void logReceivedTokens() {
        String msg = "Step #" + this.step.getNumber() + " " + this.step.getId() + " has received tokens: ";
        if (this.inputTokens.size() == 0) {
            msg = msg + "no token received";
        } else {
            ArrayList<CallSite> list = new ArrayList<CallSite>();
            for (InputPort port : this.inputTokens.keySet()) {
                int size = this.inputTokens.get((Object)port).size();
                if (port.isList() && size > 0) {
                    size = ((Data)this.inputTokens.get((Object)port).iterator().next()).size();
                }
                list.add((CallSite)((Object)(port.getName() + " (" + port.getFormat().getName() + "): " + size + (port.isList() ? " [list]" : ""))));
            }
            msg = msg + Joiner.on((String)", ").join(list);
        }
        EoulsanLogger.getLogger().fine(msg);
    }

    private void logSentTokens() {
        String msg = "Step #" + this.step.getNumber() + " " + this.step.getId() + " has sent tokens: ";
        if (this.outputTokens.size() == 0) {
            msg = msg + " no token sent";
        } else {
            ArrayList<CallSite> list = new ArrayList<CallSite>();
            for (OutputPort port : this.outputTokens.keySet()) {
                list.add((CallSite)((Object)(port.getName() + " (" + port.getFormat().getName() + "): " + this.outputTokens.get((Object)port).size())));
            }
            msg = msg + Joiner.on((String)", ").join(list);
        }
        EoulsanLogger.getLogger().fine(msg);
    }

    TokenManager(AbstractStep step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        this.step = step;
        this.inputPorts = step.getWorkflowInputPorts();
        this.outputPorts = step.getWorkflowOutputPorts();
        this.scheduler = TaskSchedulerFactory.getScheduler();
        WorkflowEventBus.getInstance().register(this);
    }
}

