/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UIEvent;

public class UIStepEvent
extends UIEvent {
    private final Step step;
    private final StepStatusMessage status;
    private final int contextId;
    private final String contextName;
    private final double progress;
    private final int terminatedTasks;
    private final int submittedTasks;
    private final String note;

    public Step getStep() {
        return this.step;
    }

    public StepStatusMessage getStatus() {
        return this.status;
    }

    public int getContextId() {
        return this.contextId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public double getProgress() {
        return this.progress;
    }

    public int getTerminatedTasks() {
        return this.terminatedTasks;
    }

    public int getSubmittedTasks() {
        return this.submittedTasks;
    }

    public String getNote() {
        return this.note;
    }

    UIStepEvent(Step step, int contextId, String contextName, double progress) {
        this.step = step;
        this.status = StepStatusMessage.PROGRESS;
        this.contextId = contextId;
        this.contextName = contextName;
        this.progress = progress;
        this.terminatedTasks = -1;
        this.submittedTasks = -1;
        this.note = null;
    }

    UIStepEvent(Step step, int terminatedTasks, int submittedTasks, double progress) {
        this.step = step;
        this.status = StepStatusMessage.TASK_PROGRESS;
        this.progress = progress;
        this.terminatedTasks = terminatedTasks;
        this.submittedTasks = submittedTasks;
        this.contextId = -1;
        this.contextName = null;
        this.note = null;
    }

    UIStepEvent(Step step, String note) {
        this.step = step;
        this.status = StepStatusMessage.NOTE;
        this.note = note;
        this.progress = -1.0;
        this.terminatedTasks = -1;
        this.submittedTasks = -1;
        this.contextId = -1;
        this.contextName = null;
    }

    static enum StepStatusMessage {
        PROGRESS,
        TASK_PROGRESS,
        NOTE;

    }
}

