/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.collect.HashMultimap;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractWorkflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStateDependencies;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class Workflow2Graphviz {
    private static final String GRAPHVIZ_COMMAND_NAME = "dot";
    private final AbstractWorkflow workflow;
    private final DataFile dotFile;
    private final DataFile imageFile;

    private void addRow(StringBuilder sb, String s) {
        sb.append("<tr><td bgcolor=\"white\" align=\"center\" colspan=\"2\"><font color=\"black\">");
        sb.append(s);
        sb.append("</font></td></tr>");
    }

    private String convert() {
        StringBuilder sb = new StringBuilder();
        sb.append("## Generated by Eoulsan ");
        sb.append(Globals.APP_VERSION_STRING);
        sb.append('\n');
        sb.append("## Command to get the layout: \"dot ");
        sb.append(StringUtils.join(this.createCommandLine(true), (String)" "));
        sb.append("\"\n");
        sb.append("digraph g {\n  graph [fontsize=30 labelloc=\"t\" label=\"\" splines=true overlap=false rankdir = \"LR\"]\n  ratio = auto;\n");
        for (Step step : this.workflow.getSteps()) {
            if (step == this.workflow.getFirstStep() || step == this.workflow.getCheckerStep()) continue;
            sb.append("  \"step");
            sb.append(step.getNumber());
            sb.append("\" [ style = \"filled\" penwidth = 1 fillcolor = \"white\" fontname = \"Courier New\" shape = \"Mrecord\" label =");
            sb.append("<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\">");
            sb.append("<tr><td bgcolor=\"black\" align=\"center\" colspan=\"2\"><font color=\"white\">");
            sb.append(step.getId());
            sb.append("</font></td></tr>");
            this.addRow(sb, step.getModuleName() + " " + step.getStepVersion());
            for (Parameter p : step.getParameters()) {
                this.addRow(sb, StringUtils.xmlEscape((String)p.getName()) + " = " + StringUtils.xmlEscape((String)p.getValue()));
            }
            sb.append("</table>> ] ;\n");
        }
        sb.append('\n');
        HashMultimap linkedSteps = HashMultimap.create();
        for (Step step : this.workflow.getSteps()) {
            if (step == this.workflow.getFirstStep() || step == this.workflow.getCheckerStep()) continue;
            int stepNumber = step.getNumber();
            AbstractStep abstractStep = (AbstractStep)step;
            for (StepOutputPort outputPort : abstractStep.getWorkflowOutputPorts()) {
                for (StepInputPort link : outputPort.getLinks()) {
                    AbstractStep linkedStep = link.getStep();
                    if (linkedStep == this.workflow.getFirstStep() || linkedStep == this.workflow.getCheckerStep()) continue;
                    linkedSteps.put((Object)linkedStep, (Object)abstractStep);
                    sb.append("  step");
                    sb.append(stepNumber);
                    sb.append(" -> step");
                    sb.append(linkedStep.getNumber());
                    sb.append(" [ penwidth = 5 fontsize = 28 fontcolor = \"black\" label = \"");
                    DataFormat format = outputPort.getFormat();
                    String formatName = format.getAlias() == null || "".equals(format.getAlias()) ? format.getName() : format.getAlias();
                    sb.append(formatName);
                    sb.append("\" ];\n");
                }
            }
        }
        for (Step step : this.workflow.getSteps()) {
            if (step == this.workflow.getFirstStep() || step == this.workflow.getCheckerStep()) continue;
            AbstractStep abstractStep = (AbstractStep)step;
            StepStateDependencies observer = ((AbstractStep)step).getStepStateDependencies();
            HashSet<AbstractStep> requiredSteps = new HashSet<AbstractStep>(observer.getRequiredSteps());
            requiredSteps.removeAll(linkedSteps.get((Object)abstractStep));
            requiredSteps.remove(this.workflow.getFirstStep());
            requiredSteps.remove(this.workflow.getCheckerStep());
            for (AbstractStep requiredStep : requiredSteps) {
                sb.append("  step");
                sb.append(requiredStep.getNumber());
                sb.append(" -> step");
                sb.append(step.getNumber());
                sb.append(" [ penwidth = 5 fontsize = 28 fontcolor = \"green\"");
                sb.append(" ];\n");
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public void saveDotFile() throws IOException {
        this.saveDotFile(this.dotFile);
    }

    private void saveDotFile(DataFile outputFile) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputFile.create());
        writer.write(this.convert());
        ((Writer)writer).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveImageFile() {
        File dotExecutableFile;
        DataFile tmpImageDataFile;
        DataFile tmpDotDataFile;
        try {
            File tmpDotFile = File.createTempFile("eoulsan-workflow-", ".dot");
            File tmpImageFile = File.createTempFile("eoulsan-workflow-", ".png");
            tmpDotDataFile = new DataFile(tmpDotFile);
            tmpImageDataFile = new DataFile(tmpImageFile);
            this.saveDotFile(tmpDotDataFile);
            DataFiles.copy(tmpDotDataFile, this.dotFile);
            dotExecutableFile = SystemUtils.searchExecutableInPATH((String)GRAPHVIZ_COMMAND_NAME);
            if (dotExecutableFile == null) {
                EoulsanLogger.logWarning("Unable to find the \"dot\" command in the PATH to create the workflow image file");
                tmpDotDataFile.delete();
                tmpImageDataFile.delete();
                return false;
            }
        }
        catch (IOException e) {
            EoulsanLogger.logWarning("Unable to create workflow image: " + e.getMessage());
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(dotExecutableFile.getAbsolutePath());
        command.addAll(Workflow2Graphviz.createCommandLine(tmpDotDataFile, tmpImageDataFile, true));
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            Process p = pb.start();
            int exitcode = p.waitFor();
            if (exitcode != 0) {
                EoulsanLogger.logWarning("Unable to create workflow image: dot exit error: " + exitcode);
                boolean bl = false;
                return bl;
            }
            DataFiles.copy(tmpImageDataFile, this.imageFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            EoulsanLogger.logWarning("Unable to create workflow image: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            tmpDotDataFile.toFile().delete();
            tmpImageDataFile.toFile().delete();
        }
    }

    private List<String> createCommandLine(boolean absolustePath) {
        return Workflow2Graphviz.createCommandLine(this.dotFile, this.imageFile, absolustePath);
    }

    private static List<String> createCommandLine(DataFile dotFile, DataFile imageFile, boolean absolustePath) {
        return Arrays.asList("-Gsize=40", "-Tpng", Workflow2Graphviz.filePath(dotFile, absolustePath), "-o", Workflow2Graphviz.filePath(imageFile, absolustePath));
    }

    private static String filePath(DataFile file, boolean absolustePath) {
        return absolustePath ? file.getSource() : file.getName();
    }

    public Workflow2Graphviz(AbstractWorkflow workflow, DataFile dotFile, DataFile imageFile) {
        Objects.requireNonNull(workflow, "workflow parameter cannot be null");
        Objects.requireNonNull(dotFile, "dotFile parameter cannot be null");
        Objects.requireNonNull(imageFile, "imageFile parameter cannot be null");
        this.workflow = workflow;
        this.dotFile = dotFile;
        this.imageFile = imageFile;
    }
}

