/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractWorkflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ExecutorArguments;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Logger;

public class WorkflowContext
implements Serializable {
    private static final long serialVersionUID = -260344001954382358L;
    private final String jobId;
    private final String host;
    private DataFile designFile;
    private DataFile workflowFile;
    private DataFile jarFile;
    private final String jobUUID;
    private final String jobDescription;
    private final String jobEnvironment;
    private String commandName = "";
    private String commandDescription = "";
    private String commandAuthor = "";
    private final AbstractWorkflow workflow;
    private final long contextCreationTime;

    public DataFile getLocalWorkingDirectory() {
        return this.workflow.getLocalWorkingDirectory();
    }

    public DataFile getHadoopWorkingDirectory() {
        return this.workflow.getHadoopWorkingDirectory();
    }

    public DataFile getOutputDirectory() {
        return this.workflow.getOutputDirectory();
    }

    public DataFile getJobDirectory() {
        return this.workflow.getJobDirectory();
    }

    public DataFile getTaskDirectory() {
        return this.workflow.getTaskDirectory();
    }

    public DataFile getDataRepositoryDirectory() {
        return this.workflow.getDataRepositoryDirectory();
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobHost() {
        return this.host;
    }

    public long getContextCreationTime() {
        return this.contextCreationTime;
    }

    public DataFile getDesignFile() {
        return this.designFile;
    }

    public DataFile getWorkflowFile() {
        return this.workflowFile;
    }

    public DataFile getJarFile() {
        return this.jarFile;
    }

    public String getJobUUID() {
        return this.jobUUID;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public String getJobEnvironment() {
        return this.jobEnvironment;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public String getCommandAuthor() {
        return this.commandAuthor;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setDesignFile(DataFile designFile) {
        this.designFile = designFile;
    }

    public void setWorkflowFile(DataFile workflowFile) {
        this.workflowFile = workflowFile;
    }

    public void setJarFile(DataFile jarFile) {
        this.jarFile = jarFile;
    }

    void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    void setCommandDescription(String commandDescription) {
        this.commandDescription = commandDescription;
    }

    void setCommandAuthor(String commandAuthor) {
        this.commandAuthor = commandAuthor;
    }

    public AbstractEoulsanRuntime getRuntime() {
        return EoulsanRuntime.getRuntime();
    }

    public Settings getSettings() {
        return this.getRuntime().getSettings();
    }

    public Logger getLogger() {
        return EoulsanLogger.getLogger();
    }

    public GenericLogger getGenericLogger() {
        return EoulsanLogger.getGenericLogger();
    }

    WorkflowContext(ExecutorArguments arguments, AbstractWorkflow workflow) {
        Objects.requireNonNull(arguments.getLocalWorkingPathname(), "arguments cannot be null");
        Objects.requireNonNull(workflow, "workflow cannot be null");
        this.workflow = workflow;
        this.jobId = arguments.getJobId();
        this.jobUUID = arguments.getJobUUID();
        this.contextCreationTime = arguments.getCreationTime();
        this.host = SystemUtils.getHostName();
        Objects.requireNonNull(arguments.getLocalWorkingPathname(), "base path cannot be null");
        Objects.requireNonNull(arguments.getWorkflowPathname(), "parameter path cannot be null");
        Objects.requireNonNull(arguments.getDesignPathname(), "design cannot be null");
        Objects.requireNonNull(arguments.getOutputPathname(), "output path cannot be null");
        Objects.requireNonNull(arguments.getJobPathname(), "log path cannot be null");
        Objects.requireNonNull(arguments.getJobDescription(), "job description cannot be null");
        Objects.requireNonNull(arguments.getJobEnvironment(), "job environment cannot be null");
        this.workflowFile = new DataFile(arguments.getWorkflowPathname());
        this.designFile = new DataFile(arguments.getDesignPathname());
        this.jobDescription = arguments.getJobDescription();
        this.jobEnvironment = arguments.getJobEnvironment();
    }
}

