/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataElement;
import fr.ens.biologie.genomique.eoulsan.core.workflow.SimpleDataMetadata;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UnmodifiableDataMetadata;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.DataMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class WorkflowDataUtils {
    public static void setDataFile(Data data, DataFile dataFile) {
        Objects.requireNonNull(data, "data cannot be null");
        if (data.isList()) {
            throw new IllegalArgumentException("data list are not handled by this method");
        }
        DataElement modifiableData = (DataElement)data;
        modifiableData.setDataFile(dataFile);
    }

    public static void setDataFile(Data data, int fileIndex, DataFile dataFile) {
        Objects.requireNonNull(data, "data argument cannot be null");
        if (data.isList()) {
            throw new IllegalArgumentException("data list are not handled by this method");
        }
        DataElement modifiableData = (DataElement)data;
        modifiableData.setDataFile(fileIndex, dataFile);
    }

    public static void setDataFiles(Data data, List<DataFile> dataFiles) {
        Objects.requireNonNull(data, "data argument cannot be null");
        if (data.isList()) {
            throw new IllegalArgumentException("data list are not handled by this method");
        }
        DataElement modifiableData = (DataElement)data;
        modifiableData.setDataFiles(dataFiles);
    }

    public static List<DataFile> getDataFiles(Data data) {
        Objects.requireNonNull(data, "data argument cannot be null");
        if (data.isList()) {
            return Collections.emptyList();
        }
        return ((DataElement)data).getDataFiles();
    }

    public static void setDataMetaData(Data data, Sample sample) {
        Objects.requireNonNull(data, "data argument cannot be null");
        Objects.requireNonNull(sample, "sample argument cannot be null");
        Preconditions.checkArgument((boolean)data.getName().equals(Naming.toValidName(sample.getId())), (Object)("The sample name (" + sample.getId() + ") does not match with data id (" + data.getName() + ")"));
        if (data.isList()) {
            return;
        }
        HashSet<String> sampleMetadataKeysToNotUse = new HashSet<String>();
        for (DataFormat dataFormat : DataFormatRegistry.getInstance().getAllFormats()) {
            if (dataFormat.getSampleMetadataKeyName() == null) continue;
            sampleMetadataKeysToNotUse.add(dataFormat.getSampleMetadataKeyName());
        }
        SimpleDataMetadata dataMetadata = (SimpleDataMetadata)data.getMetadata();
        dataMetadata.setSampleName(sample);
        dataMetadata.setSampleNumber(sample.getNumber());
        for (String string : sample.getMetadata().keySet()) {
            if (sampleMetadataKeysToNotUse.contains(string)) continue;
            dataMetadata.setSampleMetadata(sample, string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (DataFormat format : DataFormatRegistry.getInstance().getAllFormats()) {
            if (format.getSampleMetadataKeyName() == null) continue;
            hashSet.add(format.getDesignMetadataKeyName());
        }
        Design design = sample.getDesign();
        for (String key : design.getMetadata().keySet()) {
            if (hashSet.contains(key)) continue;
            dataMetadata.setDesignMetadata(design, key);
        }
        for (Experiment experiment : design.getExperimentsUsingASample(sample)) {
            for (String key : experiment.getMetadata().keySet()) {
                dataMetadata.setExperimentMetadata(experiment, key);
            }
        }
    }

    static SimpleDataMetadata getSimpleMetadata(DataMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata argument cannot be null");
        DataMetadata md = metadata;
        if (md instanceof UnmodifiableDataMetadata) {
            md = ((UnmodifiableDataMetadata)md).getMetaData();
        }
        if (md instanceof SimpleDataMetadata) {
            return (SimpleDataMetadata)md;
        }
        return null;
    }

    public static void setDataMetadata(Data data, Collection<Data> dataSourceOfMetadata) {
        Objects.requireNonNull(data, "data argument cannot be null");
        Objects.requireNonNull(dataSourceOfMetadata, "dataForMetaData argument cannot be null");
        for (Data d : dataSourceOfMetadata) {
            WorkflowDataUtils.setDataMetadata(data, d);
        }
    }

    public static void setDataMetadata(Data data, Data dataSourceOfMetadata) {
        Objects.requireNonNull(data, "data argument cannot be null");
        Objects.requireNonNull(dataSourceOfMetadata, "dataForMetaData argument cannot be null");
        if (data.isList()) {
            return;
        }
        DataMetadata metadata = data.getMetadata();
        if (dataSourceOfMetadata.isList()) {
            for (Data d : dataSourceOfMetadata.getListElements()) {
                metadata.set(d.getMetadata());
            }
        } else {
            metadata.set(dataSourceOfMetadata.getMetadata());
        }
    }

    private WorkflowDataUtils() {
    }
}

