/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStateEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.Token;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UIEvent;
import fr.ens.biologie.genomique.eoulsan.data.Data;

public class WorkflowEventBus {
    private static WorkflowEventBus singleton;
    private final EventBus eventBus = new EventBus("Eoulsan");

    public void register(Object object) {
        this.eventBus.register(object);
    }

    public void unregister(Object object) {
        this.eventBus.unregister(object);
    }

    private void post(Object object) {
        this.eventBus.post(object);
    }

    void postStepStateChange(AbstractStep step, Step.StepState state) {
        this.post(new StepStateEvent(step, state));
    }

    void postToken(StepOutputPort fromPort, int tokenCount) {
        this.post(new Token(fromPort, tokenCount));
    }

    void postToken(StepOutputPort fromPort, Data data) {
        this.post(new Token(fromPort, data));
    }

    void postUIEvent(UIEvent uiEvent) {
        this.post(uiEvent);
    }

    @Subscribe
    public void deadEvent(DeadEvent event) {
        EoulsanLogger.getLogger().severe("Dead event: " + event);
    }

    public static synchronized WorkflowEventBus getInstance() {
        if (singleton == null) {
            singleton = new WorkflowEventBus();
        }
        return singleton;
    }

    private WorkflowEventBus() {
        this.eventBus.register((Object)this);
    }
}

