/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataElement;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.util.Objects;

public class WorkflowFileNaming
extends FileNaming {
    private void set(StepOutputPort port) {
        Objects.requireNonNull(port, "port argument cannot be null");
        this.setStepId(port.getStep().getId());
        this.setPortName(port.getName());
        this.setFormat(port.getFormat());
        this.setCompression(port.getCompression());
    }

    public static String filePrefix(StepOutputPort port) {
        WorkflowFileNaming f = new WorkflowFileNaming();
        f.set(port);
        return f.filePrefix();
    }

    public static String glob(StepOutputPort port) {
        WorkflowFileNaming f = new WorkflowFileNaming();
        f.set(port);
        return f.glob();
    }

    public static String fileMiddle(StepOutputPort port, DataElement data, int fileIndex) {
        WorkflowFileNaming f = new WorkflowFileNaming();
        f.set(port);
        f.set(data);
        f.setFileIndex(fileIndex);
        return f.fileMiddle();
    }

    public static String fileMiddle(StepOutputPort port, String dataName, int fileIndex, int part) {
        WorkflowFileNaming f = new WorkflowFileNaming();
        f.set(port);
        f.setDataName(dataName);
        f.setPart(part);
        f.setFileIndex(fileIndex);
        return f.fileMiddle();
    }

    public static String fileSuffix(StepOutputPort port) {
        WorkflowFileNaming f = new WorkflowFileNaming();
        f.set(port);
        return f.fileSuffix();
    }

    public static String filename(StepOutputPort port, DataElement data, int fileIndex) {
        WorkflowFileNaming f = new WorkflowFileNaming();
        f.set(port);
        f.set(data);
        f.setFileIndex(fileIndex);
        return f.filename();
    }

    public static DataFile file(StepOutputPort port, DataElement data, int fileIndex) {
        return new DataFile(port.getStep().getStepOutputDirectory(), WorkflowFileNaming.filename(port, data, fileIndex));
    }

    private WorkflowFileNaming() {
    }
}

