/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

abstract class AbstractDataFormat
implements DataFormat {
    AbstractDataFormat() {
    }

    @Override
    public String getDescription() {
        return this.getName() + " description.";
    }

    @Override
    public List<String> getExtensions() {
        return Collections.singletonList(this.getDefaultExtension());
    }

    @Override
    public boolean isGenerator() {
        return false;
    }

    @Override
    public boolean isChecker() {
        return false;
    }

    @Override
    public Module getGenerator() {
        return null;
    }

    @Override
    public Checker getChecker() {
        return null;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public int getMaxFilesCount() {
        return 1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataFormat)) {
            return false;
        }
        DataFormat that = (DataFormat)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getContentType(), that.getContentType()) && Objects.equals(this.getDefaultExtension(), that.getDefaultExtension()) && Objects.equals(this.getExtensions(), that.getExtensions()) && Objects.equals(this.isGenerator(), that.isGenerator()) && Objects.equals(this.isChecker(), that.isChecker()) && (this.getGenerator() == null && that.getGenerator() == null || this.getGenerator() != null && that.getGenerator() != null && Objects.equals(this.getGenerator().getClass().getName(), that.getGenerator().getClass().getName())) && (this.getChecker() == null && that.getChecker() == null || this.getChecker() != null && that.getChecker() != null && Objects.equals(this.getChecker().getClass().getName(), that.getChecker().getClass().getName())) && Objects.equals(this.getMaxFilesCount(), that.getMaxFilesCount());
    }

    public int hashCode() {
        Integer extensionsHashCode = this.getExtensions() == null ? null : Integer.valueOf(this.getExtensions().hashCode());
        Integer generatorHashCode = this.isGenerator() ? Integer.valueOf(this.getGenerator().getClass().hashCode()) : null;
        Integer checkerHashCode = this.isChecker() ? Integer.valueOf(this.getChecker().getClass().hashCode()) : null;
        return Objects.hash(this.getName(), this.getDescription(), this.getContentType(), this.getDefaultExtension(), extensionsHashCode, this.isGenerator(), this.isChecker(), generatorHashCode, checkerHashCode, this.getMaxFilesCount());
    }

    public String toString() {
        Module generator = this.getGenerator();
        Checker checker = this.getChecker();
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("description", (Object)this.getDescription()).add("contentType", (Object)this.getContentType()).add("defaultExtension", (Object)this.getDefaultExtension()).add("extensions", this.getExtensions()).add("generatorClassName", generator != null ? generator.getClass().getCanonicalName() : null).add("checkerClassName", checker != null ? checker.getClass().getCanonicalName() : null).add("maxFilesCount", this.getMaxFilesCount()).toString();
    }
}

