/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocolService;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class DataFile
implements Comparable<DataFile>,
Serializable {
    private static final long serialVersionUID = -3280343485491150872L;
    public static final char separatorChar = '/';
    public static final String separator = "/";
    private String src;
    private String name;
    private String protocolPrefixInSource;
    private DataProtocol protocol;
    private DataFileMetadata md;
    private String unknownProtocolName;

    public String getSource() {
        return this.src;
    }

    public String getName() {
        return this.name;
    }

    public String getBasename() {
        return StringUtils.basename((String)this.getName());
    }

    public String getExtension() {
        return StringUtils.extensionWithoutCompressionExtension((String)this.getName());
    }

    public String getFullExtension() {
        return StringUtils.extension((String)this.getName());
    }

    public String getCompressionExtension() {
        return StringUtils.compressionExtension((String)this.getName());
    }

    public CompressionType getCompressionType() {
        return CompressionType.getCompressionTypeByFilename((String)this.getName());
    }

    public DataFormat getDataFormat() {
        return DataFormatRegistry.getInstance().getDataFormatFromFilename(this.getName());
    }

    public DataFile getParent() throws IOException {
        return this.getProtocol().getDataFileParent(this);
    }

    public DataProtocol getProtocol() throws IOException {
        if (this.protocol == null) {
            throw new IOException("Unknown protocol: " + this.unknownProtocolName);
        }
        return this.protocol;
    }

    public DataFileMetadata getMetaData() throws IOException {
        if (this.md == null) {
            this.md = this.getProtocol().getMetadata(this);
        }
        return this.md;
    }

    public String getProtocolPrefixInSource() {
        return this.protocolPrefixInSource;
    }

    public boolean isLocalFile() {
        try {
            return DataProtocolService.getInstance().getDefaultProtocol().equals(this.getProtocol());
        }
        catch (IOException e) {
            return false;
        }
    }

    public File toFile() {
        if (this.protocol == null) {
            return null;
        }
        return this.protocol.getSourceAsFile(this);
    }

    public Path toPath() {
        if (this.protocol == null) {
            return null;
        }
        URI uri = this.toUri();
        if (uri == null) {
            return null;
        }
        return Paths.get(uri);
    }

    public URI toUri() {
        try {
            return new URI(this.src);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public DataFile toRealDataFile() {
        if (!this.isLocalFile()) {
            return this;
        }
        try {
            return new DataFile(this.toFile().toPath().toRealPath(new LinkOption[0]));
        }
        catch (IOException e) {
            return this;
        }
    }

    public DataFile toAbsoluteDataFile() {
        if (!this.isLocalFile()) {
            return this;
        }
        return new DataFile(this.toFile().getAbsoluteFile());
    }

    public OutputStream create() throws IOException {
        OutputStream os = this.rawCreate();
        String contentEncoding = this.md == null ? null : this.md.getContentEncoding();
        CompressionType ct = contentEncoding != null ? CompressionType.getCompressionTypeByContentEncoding((String)contentEncoding) : CompressionType.getCompressionTypeByFilename((String)this.getName());
        if (ct == null) {
            return os;
        }
        return ct.createOutputStream(os);
    }

    public OutputStream rawCreate() throws IOException {
        return this.getProtocol().putData(this, this.md);
    }

    public InputStream open() throws IOException {
        InputStream is = this.rawOpen();
        DataFileMetadata md = this.getMetaData();
        CompressionType ct = CompressionType.getCompressionTypeByContentEncoding((String)md.getContentEncoding());
        if (ct == null) {
            return is;
        }
        return ct.createInputStream(is);
    }

    public InputStream rawOpen() throws IOException {
        return this.getProtocol().getData(this);
    }

    public void copyTo(DataFile dest) throws IOException {
        if (dest == null) {
            throw new NullPointerException("The destination DataFile is null.");
        }
        dest.getProtocol().putData(this, dest);
    }

    public boolean exists() {
        return this.exists(true);
    }

    public boolean exists(boolean followLink) {
        try {
            return this.getProtocol().exists(this, followLink);
        }
        catch (IOException e) {
            return false;
        }
    }

    public void mkdir() throws IOException {
        if (!this.getProtocol().canMkdir()) {
            throw new IOException("The underlying protocol does not allow creating directories");
        }
        this.getProtocol().mkdir(this);
    }

    public void mkdirs() throws IOException {
        if (!this.getProtocol().canMkdir()) {
            throw new IOException("The underlying protocol does not allow creating directories");
        }
        this.getProtocol().mkdirs(this);
    }

    public void symlink(DataFile link) throws IOException {
        this.symlink(link, false);
    }

    public void symlink(DataFile link, boolean relativize) throws IOException {
        if (link == null) {
            throw new NullPointerException("The link can not be null.");
        }
        if (!this.getProtocol().canSymlink()) {
            throw new IOException("The underlying protocol does not allow creating symbolic links");
        }
        if (relativize) {
            DataFile parent = this.isLocalFile() ? new DataFile(this.getParent().toFile().getAbsoluteFile()) : this.getParent();
            DataFile newTarget = new DataFile(DataFile.relativize(link.getParent(), parent), this.getName());
            this.getProtocol().symlink(newTarget, link);
        } else {
            this.getProtocol().symlink(this, link);
        }
    }

    public void delete() throws IOException {
        this.delete(false);
    }

    public void delete(boolean recursive) throws IOException {
        if (!this.getProtocol().canDelete()) {
            throw new IOException("The underlying protocol does not allow deleting files");
        }
        this.getProtocol().delete(this, recursive);
    }

    public List<DataFile> list() throws IOException {
        if (!this.getProtocol().canList()) {
            throw new IOException("The underlying protocol does not allow to list a directory");
        }
        return this.getProtocol().list(this);
    }

    public void renameTo(DataFile dest) throws IOException {
        if (!this.getProtocol().canRename()) {
            throw new IOException("The underlying protocol does not allow to rename files");
        }
        this.getProtocol().rename(this, dest);
    }

    private String findProtocol(String src) {
        int len = src.length();
        int pos = -1;
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (Character.isDigit((int)c) || Character.isLetter((int)c)) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return null;
        }
        if (len <= pos + 1) {
            return null;
        }
        if (src.charAt(pos) == ':' && src.charAt(pos + 1) == '/') {
            return src.substring(0, pos);
        }
        return null;
    }

    private void parseSource(String source) {
        this.protocolPrefixInSource = this.findProtocol(source);
        DataProtocolService registry = DataProtocolService.getInstance();
        this.protocol = this.protocolPrefixInSource == null ? registry.getDefaultProtocol() : registry.newService(this.protocolPrefixInSource);
        if (this.protocol == null) {
            EoulsanLogger.getLogger().severe("Unknown protocol: \"" + this.protocolPrefixInSource + "\", can't set protocol for DataFile.");
            this.unknownProtocolName = this.protocolPrefixInSource;
        }
        this.src = source;
        int lastSlashPos = source.lastIndexOf(47);
        this.name = lastSlashPos == -1 ? source : source.substring(lastSlashPos + 1);
    }

    private static DataFile relativize(DataFile f1, DataFile f2) {
        URI uri1 = f1.toUri();
        URI uri2 = f2.toUri();
        return new DataFile(uri1.relativize(uri2));
    }

    @Override
    public int compareTo(DataFile o) {
        if (o == null) {
            throw new NullPointerException("argument cannot be null");
        }
        return this.src.compareTo(o.src);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataFile)) {
            return false;
        }
        DataFile df = (DataFile)o;
        return this.src.equals(df.src);
    }

    public int hashCode() {
        return this.src.hashCode();
    }

    public String toString() {
        return this.src;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.src);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String source = (String)in.readObject();
        this.parseSource(source);
    }

    public DataFile(String source) {
        if (source == null) {
            throw new NullPointerException("The source can not be null.");
        }
        this.parseSource(source);
    }

    public DataFile(DataFile parentFile, String filename) {
        if (parentFile == null) {
            throw new NullPointerException("The parent file can not be null.");
        }
        if (filename == null) {
            throw new NullPointerException("The name can not be null.");
        }
        String parentSource = parentFile.getSource();
        if (parentSource == null || "".equals(parentSource)) {
            this.parseSource(filename);
        } else {
            this.parseSource(parentFile.getSource() + separator + filename);
        }
    }

    public DataFile(File parentFile, String filename) {
        this(new DataFile(parentFile), filename);
    }

    public DataFile(Path parentPath, String filename) {
        this(new DataFile(parentPath), filename);
    }

    public DataFile(File file) {
        if (file == null) {
            throw new NullPointerException("The source file can not be null.");
        }
        this.parseSource(file.getPath());
    }

    public DataFile(Path path) {
        if (path == null) {
            throw new NullPointerException("The source path can not be null.");
        }
        this.parseSource(path.toFile().getPath());
    }

    public DataFile(URI uri) {
        if (uri == null) {
            throw new NullPointerException("The source URI can not be null.");
        }
        this.parseSource(uri.toString());
    }
}

