/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.AbstractDataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.modules.generators.GenomeMapperIndexGeneratorModule;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Merger;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MapperIndexDataFormat
extends AbstractDataFormat
implements Serializable {
    private static final long serialVersionUID = -943794645213547885L;
    private final String mapperName;
    private final String formatName;
    private final String prefix;

    @Override
    public String getName() {
        return this.formatName;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isOneFilePerAnalysis() {
        return true;
    }

    @Override
    public boolean isDataFormatFromDesignFile() {
        return false;
    }

    @Override
    public String getDesignMetadataKeyName() {
        return null;
    }

    @Override
    public String getSampleMetadataKeyName() {
        return null;
    }

    @Override
    public String getDefaultExtension() {
        return ".zip";
    }

    @Override
    public List<String> getExtensions() {
        return Collections.singletonList(".zip");
    }

    @Override
    public List<String> getGalaxyFormatNames() {
        return Collections.emptyList();
    }

    @Override
    public boolean isGenerator() {
        return true;
    }

    @Override
    public boolean isChecker() {
        return false;
    }

    @Override
    public boolean isSplitter() {
        return false;
    }

    @Override
    public boolean isMerger() {
        return false;
    }

    @Override
    public Module getGenerator() {
        GenomeMapperIndexGeneratorModule generator = new GenomeMapperIndexGeneratorModule();
        Parameter mapperNameParameter = new Parameter("mapperName", this.mapperName);
        try {
            generator.configure(null, Collections.singleton(mapperNameParameter));
            return generator;
        }
        catch (EoulsanException e) {
            EoulsanLogger.getLogger().severe("Cannot create generator: " + e.getMessage());
            return null;
        }
    }

    @Override
    public Checker getChecker() {
        return null;
    }

    @Override
    public Splitter getSplitter() {
        return null;
    }

    @Override
    public Merger getMerger() {
        return null;
    }

    @Override
    public String getContentType() {
        return "application/zip";
    }

    @Override
    public int getMaxFilesCount() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataFormat)) {
            return false;
        }
        if (!(o instanceof MapperIndexDataFormat)) {
            return super.equals(o);
        }
        MapperIndexDataFormat that = (MapperIndexDataFormat)o;
        return Objects.equals(this.formatName, that.formatName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.formatName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.formatName).toString();
    }

    public MapperIndexDataFormat(Mapper mapper) {
        this(mapper.getName());
    }

    public MapperIndexDataFormat(String mapperName) {
        String mapperNameLowerCase;
        Objects.requireNonNull(mapperName);
        this.mapperName = mapperNameLowerCase = mapperName.toLowerCase();
        this.formatName = mapperNameLowerCase + "_index_zip";
        this.prefix = mapperNameLowerCase + "index";
    }
}

