/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.protocols;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

abstract class AbstractDataProtocol
implements DataProtocol {
    AbstractDataProtocol() {
    }

    @Override
    public String getSourceFilename(String source) {
        int lastSlashPos = source.lastIndexOf(47);
        if (lastSlashPos == -1) {
            return source;
        }
        return source.substring(lastSlashPos + 1);
    }

    @Override
    public DataFile getDataFileParent(DataFile src) {
        if (src == null) {
            return null;
        }
        String source = src.getSource();
        int nameLen = src.getName().length();
        int sourceLen = source.length();
        int parentSrcLen = sourceLen - nameLen - 1;
        return new DataFile(source.substring(0, parentSrcLen < 0 ? 0 : parentSrcLen));
    }

    @Override
    public OutputStream putData(DataFile src, DataFileMetadata md) throws IOException {
        if (!this.canWrite()) {
            throw new IOException("Writing is not allowed for the source: " + src);
        }
        return this.putData(src);
    }

    @Override
    public void putData(DataFile src, DataFile dest) throws IOException {
        if (src == null) {
            throw new NullPointerException("The source of the data to put is null");
        }
        if (dest == null) {
            throw new NullPointerException("The destination of the data to put is null");
        }
        DataFileMetadata mdSrc = src.getMetaData();
        FileUtils.copy((InputStream)src.getProtocol().getData(src), (OutputStream)dest.getProtocol().putData(dest, mdSrc));
    }

    @Override
    public File getSourceAsFile(DataFile src) {
        if (src == null || src.getSource() == null) {
            throw new NullPointerException("The source is null.");
        }
        return null;
    }

    @Override
    public void mkdir(DataFile dir) throws IOException {
        throw new IOException("The mkdir() method is not supported by the " + this.getName() + " protocol");
    }

    @Override
    public void mkdirs(DataFile dir) throws IOException {
        throw new IOException("The mkdir() method is not supported by the " + this.getName() + " protocol");
    }

    @Override
    public boolean canMkdir() {
        return false;
    }

    @Override
    public void symlink(DataFile target, DataFile link) throws IOException {
        throw new IOException("The symlink() method is not supported by the " + this.getName() + " protocol");
    }

    @Override
    public boolean canSymlink() {
        return false;
    }

    @Override
    public void delete(DataFile file, boolean recursive) throws IOException {
        throw new IOException("The delete() method is not supported by the " + this.getName() + " protocol");
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public List<DataFile> list(DataFile file) throws IOException {
        throw new IOException("The list() method is not supported by the " + this.getName() + " protocol");
    }

    @Override
    public boolean canList() {
        return false;
    }

    @Override
    public boolean canRename() {
        return false;
    }

    @Override
    public void rename(DataFile oldName, DataFile newName) throws IOException {
        throw new IOException("The rename() method is not supported by the " + this.getName() + " protocol");
    }
}

