/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.protocols;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.annotations.ExecutionMode;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.FileDataProtocol;
import fr.ens.biologie.genomique.kenetre.util.ServiceNameLoader;

public class DataProtocolService
extends ServiceNameLoader<DataProtocol> {
    private static DataProtocolService service;
    private final FileDataProtocol defaultProtocol = new FileDataProtocol();
    private final String defaultProtocolName = this.defaultProtocol.getName();

    public static synchronized DataProtocolService getInstance() {
        if (service == null) {
            service = new DataProtocolService();
        }
        return service;
    }

    protected boolean isCache() {
        return true;
    }

    public FileDataProtocol getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public DataProtocol newService(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        String lower = serviceName.trim().toLowerCase();
        if (lower.equals(this.defaultProtocolName)) {
            return this.defaultProtocol;
        }
        return (DataProtocol)super.newService(serviceName);
    }

    public ListMultimap<String, String> getServiceClasses() {
        ArrayListMultimap result = ArrayListMultimap.create((Multimap)super.getServiceClasses());
        result.put((Object)this.defaultProtocolName, (Object)this.defaultProtocol.getClass().getName());
        return Multimaps.unmodifiableListMultimap((ListMultimap)result);
    }

    public boolean isService(String serviceName) {
        if (serviceName == null) {
            return false;
        }
        String lower = serviceName.trim().toLowerCase();
        if (lower.equals(this.defaultProtocolName)) {
            return true;
        }
        return super.isService(serviceName);
    }

    protected boolean accept(Class<?> clazz) {
        return ExecutionMode.accept(clazz, EoulsanRuntime.getRuntime().getMode().isHadoopProtocolMode());
    }

    protected String getMethodName() {
        return "getName";
    }

    private DataProtocolService() {
        super(DataProtocol.class);
    }
}

