/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.protocols;

import fr.ens.biologie.genomique.eoulsan.annotations.HadoopOnly;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.protocols.PathDataProtocol;
import fr.ens.biologie.genomique.eoulsan.io.PathConcatInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@HadoopOnly
public class HDFSPathDataProtocol
extends PathDataProtocol {
    public static final String PROTOCOL_NAME = "hdfs";

    @Override
    public String getName() {
        return PROTOCOL_NAME;
    }

    @Override
    public InputStream getData(DataFile src) throws IOException {
        List<Path> paths;
        Path path = this.getPath(src);
        if (path == null) {
            throw new NullPointerException("Path to create is null");
        }
        if (this.conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(this.conf);
        if (fs == null) {
            throw new IOException("Unable to create InputSteam, The FileSystem is null");
        }
        FileStatus fStatus = fs.getFileStatus(path);
        if (fStatus.isDirectory() && (paths = this.getPathToConcat(fs, path)) != null && paths.size() > 0) {
            return new PathConcatInputStream(paths, this.conf);
        }
        return fs.open(path);
    }

    private List<Path> getPathToConcat(FileSystem fs, Path path) throws IOException {
        FileStatus[] files = fs.listStatus(path, p -> p.getName().matches("^part-.*[0-9]+$"));
        Arrays.sort(files, Comparator.comparing(f -> f.getPath().getName()));
        ArrayList<Path> result = new ArrayList<Path>(files.length);
        for (FileStatus file : files) {
            result.add(file.getPath());
        }
        return result;
    }

    @Override
    public void mkdir(DataFile dir) throws IOException {
        this.mkdirs(dir);
    }

    @Override
    public void mkdirs(DataFile dir) throws IOException {
        Path path = this.getPath(dir);
        if (path == null) {
            throw new NullPointerException("Path to create is null");
        }
        if (this.conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(this.conf);
        if (fs == null) {
            throw new IOException("Unable to create the directory, The FileSystem is null");
        }
        if (!fs.mkdirs(path)) {
            throw new IOException("Unable to create the directory: " + dir);
        }
    }

    @Override
    public boolean canMkdir() {
        return true;
    }

    @Override
    public void delete(DataFile file, boolean recursive) throws IOException {
        Path path = this.getPath(file);
        if (path == null) {
            throw new NullPointerException("Path to delete is null");
        }
        if (this.conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(this.conf);
        if (fs == null) {
            throw new IOException("Unable to delete the file, The FileSystem is null");
        }
        if (!fs.delete(path, recursive)) {
            throw new IOException("Unable to delete the directory: " + file);
        }
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public List<DataFile> list(DataFile file) throws IOException {
        Path path = this.getPath(file);
        if (path == null) {
            throw new NullPointerException("Path to delete is null");
        }
        if (this.conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(this.conf);
        if (fs == null) {
            throw new IOException("Unable to delete the file, The FileSystem is null");
        }
        FileStatus fileStatus = fs.getFileStatus(path);
        if (!fs.exists(path)) {
            throw new FileNotFoundException("File not found: " + file);
        }
        if (!fileStatus.isDirectory()) {
            throw new IOException("The file is not a directory: " + file);
        }
        FileStatus[] files = fs.listStatus(path);
        ArrayList<DataFile> result = new ArrayList<DataFile>(files.length);
        for (FileStatus f : files) {
            result.add(new DataFile(f.getPath().toUri().toString()));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean canList() {
        return true;
    }

    @Override
    public void rename(DataFile file, DataFile dest) throws IOException {
        if (dest == null) {
            throw new NullPointerException("dest argument is null");
        }
        if (dest.getProtocol() != this) {
            throw new IOException("the protocol of the dest is not " + this.getName() + " protocol: " + dest);
        }
        Path path = this.getPath(file);
        Path newPath = this.getPath(dest);
        FileSystem fs = path.getFileSystem(this.conf);
        fs.rename(path, newPath);
    }

    @Override
    public boolean canRename() {
        return true;
    }
}

