/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.protocols;

import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.protocols.AbstractDataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.SimpleDataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.PathUtils;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class PathDataProtocol
extends AbstractDataProtocol {
    protected Configuration conf;

    public Path getPath(DataFile dataFile) {
        if (dataFile == null) {
            throw new NullPointerException("The source is null.");
        }
        return new Path(dataFile.getSource());
    }

    @Override
    public InputStream getData(DataFile src) throws IOException {
        return PathUtils.createInputStream(this.getPath(src), this.conf);
    }

    @Override
    public OutputStream putData(DataFile src) throws IOException {
        return PathUtils.createOutputStream(this.getPath(src), this.conf);
    }

    @Override
    public DataFileMetadata getMetadata(DataFile src) throws IOException {
        if (!this.exists(src, true)) {
            throw new FileNotFoundException("File not found: " + src);
        }
        Path path = this.getPath(src);
        FileStatus status = path.getFileSystem(this.conf).getFileStatus(path);
        SimpleDataFileMetadata result = new SimpleDataFileMetadata();
        result.setContentLength(status.getLen());
        result.setLastModified(status.getModificationTime());
        result.setDataFormat(DataFormatRegistry.getInstance().getDataFormatFromFilename(src.getName()));
        CompressionType ct = CompressionType.getCompressionTypeByFilename((String)src.getSource());
        if (ct != null) {
            result.setContentEncoding(ct.getContentEncoding());
        }
        if (status.isDirectory()) {
            result.setDirectory(true);
        }
        if (status.isSymlink()) {
            result.setSymbolicLink(new DataFile(status.getSymlink().toUri()));
        }
        return result;
    }

    @Override
    public boolean exists(DataFile src, boolean followLink) {
        Path path = this.getPath(src);
        try {
            FileSystem fs = path.getFileSystem(this.conf);
            FileStatus status = fs.getFileStatus(path);
            if (status == null) {
                return false;
            }
            if (status.isSymlink()) {
                return fs.getFileStatus(fs.getLinkTarget(path)) != null;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public PathDataProtocol() {
        AbstractEoulsanRuntime runtime = EoulsanRuntime.getRuntime();
        if (!runtime.getMode().isHadoopProtocolMode() || !(runtime instanceof HadoopEoulsanRuntime)) {
            throw new IllegalStateException("Can only create PathDataProtocol in hadoop mode.");
        }
        HadoopEoulsanRuntime hadoopRuntime = (HadoopEoulsanRuntime)runtime;
        this.conf = hadoopRuntime.getConfiguration();
        if (this.conf == null) {
            throw new NullPointerException("The Hadoop configuration object is null");
        }
    }
}

