/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.protocols;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.protocols.AbstractDataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.storages.DataFileStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public abstract class StorageDataProtocol
extends AbstractDataProtocol {
    protected abstract String getBasePath();

    protected String getExtension() {
        throw new NullPointerException("No extension has been defined for the storage protocol: " + this.getName());
    }

    protected List<String> getExtensions() {
        return Collections.singletonList(this.getExtension());
    }

    @Override
    public InputStream getData(DataFile src) throws IOException {
        return this.getUnderLyingData(src).rawOpen();
    }

    @Override
    public OutputStream putData(DataFile dest) throws IOException {
        throw new IOException("PutData() method is no supported by " + this.getName() + " protocol");
    }

    @Override
    public boolean exists(DataFile src, boolean followLink) {
        try {
            return this.getUnderLyingData(src).exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public DataFileMetadata getMetadata(DataFile src) throws IOException {
        return this.getUnderLyingData(src).getMetaData();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public File getSourceAsFile(DataFile src) {
        try {
            return this.getUnderLyingData(src).toFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataFile getUnderLyingData(DataFile src) throws IOException {
        String basePath = this.getBasePath();
        if (basePath == null) {
            throw new IOException(this.getName() + " storage is not configured");
        }
        DataFileStorage storage = new DataFileStorage(basePath, this.getExtensions());
        DataFile result = storage.getDataFile(src.getName());
        if (result == null) {
            throw new IOException("No " + this.getName() + " found for: " + src.getName());
        }
        return result;
    }
}

