/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.protocols;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.protocols.AbstractDataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.SimpleDataFileMetadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public abstract class URLDataProtocol
extends AbstractDataProtocol {
    private URLConnection createConnection(DataFile src) throws IOException {
        if (src == null) {
            throw new NullPointerException("The source is null.");
        }
        try {
            return new URL(src.getSource()).openConnection();
        }
        catch (MalformedURLException e) {
            throw new IOException("Invalid URL: " + src);
        }
    }

    @Override
    public InputStream getData(DataFile src) throws IOException {
        return this.createConnection(src).getInputStream();
    }

    @Override
    public OutputStream putData(DataFile src) throws IOException {
        return this.createConnection(src).getOutputStream();
    }

    @Override
    public DataFileMetadata getMetadata(DataFile src) throws IOException {
        if (!this.exists(src, true)) {
            throw new FileNotFoundException("File not found: " + src);
        }
        URLConnection con = this.createConnection(src);
        SimpleDataFileMetadata result = new SimpleDataFileMetadata();
        result.setContentLength(con.getContentLength());
        result.setLastModified(con.getLastModified());
        result.setContentType(con.getContentType());
        result.setContentEncoding(con.getContentEncoding());
        return result;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean exists(DataFile src, boolean followLink) {
        try {
            this.createConnection(src);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

