/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.storages;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DataFileDataPath
implements DataPath,
Comparable<DataFileDataPath> {
    private final DataFile file;

    public DataFile getDataFile() {
        return this.file;
    }

    public DataPath canonicalize() throws IOException {
        if (!this.file.isLocalFile()) {
            return this;
        }
        return new DataFileDataPath(new DataFile(this.file.toFile().getCanonicalFile()));
    }

    public OutputStream create() throws IOException {
        return this.file.create();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getContentLength() {
        try {
            DataFileMetadata md = this.file.getMetaData();
            return md.getContentLength();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public long getLastModified() {
        try {
            DataFileMetadata md = this.file.getMetaData();
            return md.getLastModified();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public String getName() {
        return this.file.getName();
    }

    public String getSource() {
        return this.file.getSource();
    }

    public List<DataPath> list() throws IOException {
        if (!this.file.getProtocol().canList()) {
            return Collections.emptyList();
        }
        ArrayList<DataPath> result = new ArrayList<DataPath>();
        for (DataFile f : this.file.list()) {
            result.add(new DataFileDataPath(f));
        }
        return result;
    }

    public InputStream open() throws IOException {
        return this.file.open();
    }

    public OutputStream rawCreate() throws IOException {
        return this.file.rawCreate();
    }

    public InputStream rawOpen() throws IOException {
        return this.file.rawOpen();
    }

    public File toFile() {
        return this.file.toFile();
    }

    public void copy(DataPath output) throws IOException {
        Objects.requireNonNull(output);
        FileUtils.copy((InputStream)this.open(), (OutputStream)output.create());
    }

    public void symlinkOrCopy(DataPath link) throws IOException {
        Objects.requireNonNull(link);
        if (!(link instanceof DataFileDataPath)) {
            this.copy(link);
        }
        DataFile output = ((DataFileDataPath)link).file;
        DataFiles.symlinkOrCopy(this.file, output);
    }

    @Override
    public int compareTo(DataFileDataPath o) {
        if (o == null) {
            return -1;
        }
        return this.file.compareTo(o.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        return this.file.equals(obj);
    }

    public String toString() {
        return this.file.toString();
    }

    public DataFileDataPath(String source) {
        Objects.requireNonNull(source);
        this.file = new DataFile(source);
    }

    public DataFileDataPath(DataFile file) {
        Objects.requireNonNull(file);
        this.file = file;
    }

    public DataFileDataPath(DataPath parent, String filename) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(filename);
        if (!(parent instanceof DataFileDataPath)) {
            throw new IllegalArgumentException("parent is not a DataFileDataPath object");
        }
        DataFileDataPath p = (DataFileDataPath)parent;
        this.file = new DataFile(p.file, filename);
    }
}

