/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.storages;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.storages.DataFileDataPath;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.storage.AbstractFileGenomeIndexStorage;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import fr.ens.biologie.genomique.kenetre.storage.GenomeIndexStorage;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class DataFileGenomeIndexStorage
extends AbstractFileGenomeIndexStorage {
    protected DataPath newDataPath(String source) {
        return new DataFileDataPath(source);
    }

    protected DataPath newDataPath(DataPath parent, String filename) {
        return new DataFileDataPath(parent, filename);
    }

    public DataFile getDataFile(MapperInstance mapperInstance, GenomeDescription genome, Map<String, String> additionalDescription) {
        DataPath result = this.getDataPath(mapperInstance, genome, additionalDescription);
        return ((DataFileDataPath)result).getDataFile();
    }

    public void put(MapperInstance mapperInstance, GenomeDescription genome, Map<String, String> additionalDescription, DataFile indexArchive) {
        Objects.requireNonNull(indexArchive, "IndexArchive is null");
        this.put(mapperInstance, genome, additionalDescription, new DataFileDataPath(indexArchive));
    }

    public static GenomeIndexStorage getInstance(String source, GenericLogger logger) {
        Objects.requireNonNull(source);
        try {
            return new DataFileGenomeIndexStorage(new DataFileDataPath(source), logger);
        }
        catch (IOException | NullPointerException e) {
            return null;
        }
    }

    protected DataFileGenomeIndexStorage(DataPath dir, GenericLogger logger) throws IOException {
        super(dir, logger);
    }
}

