/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.design.Metadata;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractMetadata
implements Metadata,
Serializable {
    private static final long serialVersionUID = 5756414666624839231L;
    private final Map<String, String> metadata = new LinkedHashMap<String, String>();

    @Override
    public String get(String key) {
        Objects.requireNonNull(key, "key argument cannot be null");
        return this.metadata.get(key.trim());
    }

    @Override
    public String getTrimmed(String key) {
        String value = this.get(key);
        return value != null ? value.trim() : null;
    }

    @Override
    public void set(String key, String value) {
        Objects.requireNonNull(key, "key argument cannot be null");
        Objects.requireNonNull(value, "value argument cannot be null");
        this.metadata.put(key, value);
    }

    @Override
    public void set(String key, List<String> value) {
        Objects.requireNonNull(key, "key argument cannot be null");
        Objects.requireNonNull(value, "value argument cannot be null");
        switch (value.size()) {
            case 0: {
                this.set(key, "");
                break;
            }
            case 1: {
                this.set(key, value.get(0));
                break;
            }
            default: {
                this.set(key, StringUtils.serializeStringArray(value));
            }
        }
    }

    @Override
    public int size() {
        return this.metadata.size();
    }

    @Override
    public boolean isEmpty() {
        return this.metadata.isEmpty();
    }

    @Override
    public boolean contains(String key) {
        Objects.requireNonNull(key, "key argument cannot be null");
        return this.metadata.containsKey(key.trim());
    }

    @Override
    public List<String> getAsList(String key) {
        Objects.requireNonNull(key, "key argument cannot be null");
        return StringUtils.deserializeStringArray((String)this.get(key.trim()));
    }

    @Override
    public boolean getAsBoolean(String key) {
        Objects.requireNonNull(key, "key argument cannot be null");
        String value = this.get(key.trim());
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value.toLowerCase());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.metadata.keySet());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(this.metadata.entrySet());
    }

    @Override
    public void remove(String key) {
        Objects.requireNonNull(key, "key argument cannot be null");
        this.metadata.remove(key.trim());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metadata", this.metadata).toString();
    }

    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMetadata)) {
            return false;
        }
        AbstractMetadata that = (AbstractMetadata)o;
        return Objects.equals(this.metadata, that.metadata);
    }
}

