/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleMetadataImpl;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

class SampleImpl
implements Serializable,
Sample {
    private static final long serialVersionUID = 3674095532228721218L;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private final Design design;
    private final String sampleId;
    private final int sampleNumber = instanceCount.incrementAndGet();
    private String sampleName = "Sample" + this.sampleNumber;
    private final SampleMetadataImpl sampleMetadata = new SampleMetadataImpl();

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public String getId() {
        return this.sampleId;
    }

    @Override
    public int getNumber() {
        return this.sampleNumber;
    }

    @Override
    public String getName() {
        return this.sampleName;
    }

    @Override
    public SampleMetadataImpl getMetadata() {
        return this.sampleMetadata;
    }

    @Override
    public void setName(String newSampleName) {
        Objects.requireNonNull(newSampleName, "newSampleName argument cannot be null");
        String name = newSampleName.trim();
        if (name.equals(this.sampleName)) {
            return;
        }
        Preconditions.checkArgument((!this.design.containsSampleName(name) ? 1 : 0) != 0, (Object)("The sample name already exists in the design: " + name));
        this.sampleName = name;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sampleId", (Object)this.sampleId).add("sampleNumber", this.sampleNumber).add("sampleName", (Object)this.sampleName).add("sampleMetadata", (Object)this.sampleMetadata).toString();
    }

    public int hashCode() {
        return Objects.hash(this.sampleId, this.sampleNumber, this.sampleName, this.sampleMetadata);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SampleImpl)) {
            return false;
        }
        SampleImpl that = (SampleImpl)o;
        return Objects.equals(this.sampleId, that.sampleId) && Objects.equals(this.sampleName, that.sampleName) && Objects.equals(this.sampleMetadata, that.sampleMetadata);
    }

    SampleImpl(Design design, String sampleId) {
        Objects.requireNonNull(design, "design argument cannot be null");
        Objects.requireNonNull(sampleId, "sampleId argument cannot be null");
        Preconditions.checkArgument((boolean)FileNaming.isDataNameValid(sampleId), (Object)("The id of a sample can only contains letters and digit: " + sampleId));
        this.design = design;
        this.sampleId = sampleId.trim();
    }
}

