/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design.io;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignFormatFinderInputStream;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class DefaultDesignReader
implements DesignReader {
    final InputStream is;

    @Override
    public Design read() throws IOException {
        try (DesignFormatFinderInputStream dffis = new DesignFormatFinderInputStream(this.is);){
            Design design = dffis.getDesignReader().read();
            return design;
        }
    }

    public DefaultDesignReader(File file) throws FileNotFoundException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.is = new FileInputStream(file);
    }

    public DefaultDesignReader(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.is = file.open();
    }

    public DefaultDesignReader(InputStream is) throws IOException {
        Objects.requireNonNull(is, "is argument cannot be null");
        this.is = is;
    }

    public DefaultDesignReader(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "filename argument cannot be null");
        this.is = new FileInputStream(filename);
    }
}

