/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design.io;

import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignReader;
import fr.ens.biologie.genomique.eoulsan.design.io.Eoulsan1DesignReader;
import fr.ens.biologie.genomique.eoulsan.design.io.Eoulsan2DesignReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DesignFormatFinderInputStream
extends InputStream
implements AutoCloseable {
    private InputStream is;
    private static final int CACHE_SIZE = 5000;
    private static final int MAX_LINES_TO_READ = 100;
    private int versionFormat;
    private boolean testFormatDone;
    private int cacheIndex;
    private byte[] cache;

    private int findFormatVersion() throws IOException {
        byte[] readed = new byte[5000];
        int count = this.is.read(readed);
        if (count != 5000) {
            this.cache = new byte[count];
            System.arraycopy(readed, 0, this.cache, 0, count);
        } else {
            this.cache = readed;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.cache), Globals.DEFAULT_CHARSET));){
            String line;
            int lineCount = 0;
            while ((line = reader.readLine()) != null && lineCount < 100) {
                if ("".equals(line = line.trim()) || line.startsWith("#") || line.startsWith("[")) continue;
                if (line.startsWith("SampleNumber\t")) {
                    int n = 1;
                    return n;
                }
                if (line.startsWith("DesignFormatVersion=")) {
                    int equalPos = line.indexOf(61);
                    String version = line.substring(equalPos + 1).replaceAll("\\s", "");
                    try {
                        int n = Integer.parseInt(version);
                        return n;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Unknown Design format version: " + version);
                    }
                }
                ++lineCount;
            }
        }
        return -1;
    }

    public int getDesignFormatVersion() throws IOException {
        if (!this.testFormatDone) {
            this.versionFormat = this.findFormatVersion();
        }
        return this.versionFormat;
    }

    public DesignReader getDesignReader() throws IOException {
        switch (this.getDesignFormatVersion()) {
            case 1: {
                return new Eoulsan1DesignReader(this);
            }
            case 2: {
                return new Eoulsan2DesignReader(this);
            }
        }
        throw new IOException("Unknown Design format");
    }

    @Override
    public int read() throws IOException {
        if (this.cacheIndex == -1) {
            return -1;
        }
        if (this.cacheIndex < this.cache.length) {
            return this.cache[this.cacheIndex++];
        }
        return this.is.read();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.cacheIndex = -1;
    }

    public DesignFormatFinderInputStream(InputStream is) {
        if (is == null) {
            throw new NullPointerException("The inputStream is null");
        }
        this.is = is;
    }
}

