/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design.io;

import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignFactory;
import fr.ens.biologie.genomique.eoulsan.design.SampleImpl;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Eoulsan1DesignReader
implements DesignReader {
    private static final String TAB_SEPARATOR = "\t";
    static final String SAMPLE_NUMBER_FIELD = "SampleNumber";
    static final String SAMPLE_NAME_FIELD = "Name";
    static final String FILENAME_FIELD = "FileName";
    static final String READS_FIELD = "Reads";
    static final String EXPERIMENT_FIELD = "Experiment";
    private final InputStream is;

    private Map<String, String> defineDesignMetadataFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Genome", "GenomeFile");
        map.put("Annotation", "GffFile");
        map.put("AdditionalAnnotation", "AdditionalAnnotationFile");
        map.put("GenomeFile", "GenomeFile");
        map.put("GffFile", "GffFile");
        map.put("GtfFile", "GtfFile");
        map.put("AdditionalAnnotationFile", "AdditionalAnnotationFile");
        return Collections.unmodifiableMap(map);
    }

    private Map<String, String> defineSampleMetadataFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(READS_FIELD, READS_FIELD);
        map.put("FastqFormat", "FastqFormat");
        map.put("Condition", "Condition");
        map.put("RepTechGroup", "RepTechGroup");
        map.put("Reference", "Reference");
        map.put("UUID", "UUID");
        map.put("Operator", "Operator");
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Design read() throws IOException {
        ArrayList<String> fieldnames = new ArrayList<String>();
        Design design = DesignFactory.createEmptyDesign();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is, Globals.DEFAULT_CHARSET));){
            String line = null;
            boolean firstLine = true;
            Map<String, String> designMetadataFields = this.defineDesignMetadataFields();
            Map<String, String> sampleMetadataFields = this.defineSampleMetadataFields();
            int idFieldIndex = -1;
            int nameFieldIndex = -1;
            int experimentFieldIndex = -1;
            while ((line = br.readLine()) != null) {
                String empty = line.trim();
                if ("".equals(empty) || empty.startsWith("#")) continue;
                String[] fields = line.split(TAB_SEPARATOR);
                if (firstLine) {
                    block16: for (int i = 0; i < fields.length; ++i) {
                        String field = fields[i].trim();
                        if ("".equals(field)) {
                            throw new IOException("Found an empty field name in design file header.");
                        }
                        if (field.equals(FILENAME_FIELD)) {
                            fields[i] = field = READS_FIELD;
                        }
                        if (fieldnames.contains(field)) {
                            throw new IOException("There is two or more field \"" + field + "\" in design file header.");
                        }
                        fieldnames.add(field);
                        switch (field) {
                            case "SampleNumber": {
                                idFieldIndex = i;
                                continue block16;
                            }
                            case "Name": {
                                nameFieldIndex = i;
                                continue block16;
                            }
                            case "Experiment": {
                                experimentFieldIndex = i;
                                continue block16;
                            }
                        }
                    }
                    if (idFieldIndex != 0) {
                        throw new IOException("Invalid file format: The \"SampleNumber\" field is not the first field.");
                    }
                    if (nameFieldIndex != 1) {
                        throw new IOException("Invalid file format: The \"Name\" field is not the second field.");
                    }
                    firstLine = false;
                    continue;
                }
                if (fields.length != fieldnames.size()) {
                    throw new IOException("Invalid file format: Found " + fields.length + " fields whereas " + fieldnames.size() + " are required in line: " + line);
                }
                SampleImpl sample = null;
                for (int i = 0; i < fields.length; ++i) {
                    String mdKey;
                    String value = fields[i].trim();
                    String fieldName = (String)fieldnames.get(i);
                    if (i == idFieldIndex) continue;
                    if (i == nameFieldIndex) {
                        sample = design.addSample(Naming.toValidName(value));
                        sample.setName(value);
                        continue;
                    }
                    if (i == experimentFieldIndex) {
                        String experimentId = Naming.toValidName(value);
                        if (!design.containsExperiment(experimentId)) {
                            design.addExperiment(experimentId);
                            design.getExperiment(experimentId).setName(value);
                        }
                        design.getExperiment(experimentId).addSample(sample);
                        continue;
                    }
                    if (designMetadataFields.containsKey(fieldName)) {
                        mdKey = designMetadataFields.get(fieldName);
                        if (design.getMetadata().contains(mdKey)) continue;
                        design.getMetadata().set(mdKey, value);
                        continue;
                    }
                    mdKey = sampleMetadataFields.getOrDefault(fieldName, fieldName);
                    sample.getMetadata().set(mdKey, value);
                }
            }
        }
        if (!fieldnames.contains(READS_FIELD)) {
            throw new IOException("Invalid file format: No Reads field");
        }
        return design;
    }

    public Eoulsan1DesignReader(File file) throws FileNotFoundException {
        Objects.requireNonNull(file, "the file argument cannot be null");
        this.is = new FileInputStream(file);
    }

    public Eoulsan1DesignReader(InputStream is) throws IOException {
        Objects.requireNonNull(is, "the is argument cannot be null");
        this.is = is;
    }

    public Eoulsan1DesignReader(DataFile file) throws IOException {
        Objects.requireNonNull(file, "the file argument cannot be null");
        this.is = file.open();
    }

    public Eoulsan1DesignReader(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "the filename argument cannot be null");
        this.is = new FileInputStream(filename);
    }
}

