/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design.io;

import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSampleMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleMetadata;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Eoulsan2DesignWriter
implements DesignWriter {
    private final OutputStream out;
    private static final String HEADER_SECTION = "[Header]";
    private static final String EXPERIMENT_SECTION = "[Experiments]";
    private static final String COLUMN_SECTION = "[Columns]";
    private static final String NEWLINE = "\r\n";

    @Override
    public void write(Design design) throws IOException {
        Objects.requireNonNull(design, "Design argument cannot be null");
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.out, Globals.DEFAULT_CHARSET));
        Objects.requireNonNull(design, "design argument cannot be null");
        bw.append(HEADER_SECTION);
        bw.append(NEWLINE);
        bw.append("DesignFormatVersion");
        bw.append('=');
        bw.append("2");
        bw.append(NEWLINE);
        for (Map.Entry<String, String> entry : design.getMetadata().entrySet()) {
            bw.append(entry.getKey());
            bw.append('=');
            bw.append(entry.getValue());
            bw.append(NEWLINE);
        }
        bw.append(NEWLINE);
        if (!design.getExperiments().isEmpty()) {
            bw.append(EXPERIMENT_SECTION);
            bw.append(NEWLINE);
        }
        for (Experiment experiment : design.getExperiments()) {
            String expId = experiment.getId();
            bw.append("Exp.");
            bw.append(expId).append('.');
            bw.append("name");
            bw.append('=');
            bw.append(experiment.getName());
            bw.append(NEWLINE);
            for (Map.Entry<String, String> m : experiment.getMetadata().entrySet()) {
                bw.append("Exp.");
                bw.append(expId);
                bw.append('.');
                bw.append(m.getKey());
                bw.append('=');
                bw.append(m.getValue());
                bw.append(NEWLINE);
            }
            bw.append(NEWLINE);
        }
        bw.append(COLUMN_SECTION);
        bw.append(NEWLINE);
        bw.append("SampleId");
        bw.append('\t');
        bw.append("SampleName");
        List<String> sampleMDKeys = DesignUtils.getAllSamplesMetadataKeys(design);
        for (String key : sampleMDKeys) {
            if ("UUID".equals(key)) continue;
            bw.append('\t');
            bw.append(key);
        }
        for (Experiment experiment : design.getExperiments()) {
            String prefix = "Exp." + experiment.getId() + ".";
            List<String> experimentMDKeys = DesignUtils.getExperimentSampleAllMetadataKeys(experiment);
            for (String key : experimentMDKeys) {
                bw.append('\t');
                bw.append(prefix);
                bw.append(key);
            }
        }
        if (sampleMDKeys.contains("UUID")) {
            bw.append('\t');
            bw.append("UUID");
        }
        bw.append(NEWLINE);
        for (Sample sample : design.getSamples()) {
            bw.append(sample.getId());
            bw.append('\t');
            bw.append(sample.getName());
            SampleMetadata smd = sample.getMetadata();
            for (String key : sampleMDKeys) {
                if ("UUID".equals(key)) continue;
                bw.append('\t');
                if (!smd.contains(key)) continue;
                bw.append(smd.get(key));
            }
            for (Experiment experiment : design.getExperiments()) {
                if (!experiment.containsSample(sample)) continue;
                ExperimentSampleMetadata expSampleMetadata = experiment.getExperimentSample(sample).getMetadata();
                List<String> experimentMDKeys = DesignUtils.getExperimentSampleAllMetadataKeys(experiment);
                for (String key : experimentMDKeys) {
                    bw.append('\t');
                    if (!expSampleMetadata.contains(key)) continue;
                    bw.append(expSampleMetadata.get(key));
                }
            }
            if (sampleMDKeys.contains("UUID")) {
                bw.append('\t');
                bw.append(smd.get("UUID"));
            }
            bw.append(NEWLINE);
        }
        bw.close();
    }

    public Eoulsan2DesignWriter(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.out = new FileOutputStream(file);
    }

    public Eoulsan2DesignWriter(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.out = file.create();
    }

    public Eoulsan2DesignWriter(OutputStream out) throws IOException {
        Objects.requireNonNull(out, "out argument cannot be null");
        this.out = out;
    }

    public Eoulsan2DesignWriter(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "filename argument cannot be null");
        this.out = new FileOutputStream(filename);
    }
}

