/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public class CheetahInterpreter {
    public static final String VAR_CMD_NAME = "cmd";
    public static final String PYTHON_VARIABLES_DICT_NAME = "galaxy_dict";
    public static final String CALL_METHOD = "galaxy_dict.get";
    static final String DEFAULT_VALUE_NULL = "no_authorized";
    private final String cheetahScript;
    private final Map<String, String> variables;

    public String execute() throws EoulsanException {
        try (PythonInterpreter interpreter = new PythonInterpreter();){
            PyStrDictionary nameSpace = CheetahInterpreter.createNameSpace(this.variables);
            interpreter.set("template", (Object)this.cheetahScript);
            interpreter.set("nameSpace", (PyObject)nameSpace);
            String pythonScript = "from Cheetah.Template import Template\nresult = str(Template(template, searchList=[nameSpace]))";
            interpreter.exec("from Cheetah.Template import Template\nresult = str(Template(template, searchList=[nameSpace]))");
            PyObject cmd = interpreter.get("result");
            String string = cmd.asString().replace('\n', ' ').trim();
            return string;
        }
    }

    private static PyStrDictionary createNameSpace(Map<String, String> plateholders) {
        PyStrDictionary result = new PyStrDictionary();
        if (plateholders != null) {
            for (Map.Entry<String, String> e : plateholders.entrySet()) {
                List fields = GuavaCompatibility.splitToList((Splitter)Splitter.on((char)'.'), (CharSequence)e.getKey());
                PyStrDictionary dict = result;
                for (int i = 0; i < fields.size() - 1; ++i) {
                    String f = (String)fields.get(i);
                    if (dict.containsKey(f)) {
                        Object o = dict.get(f);
                        if (o instanceof String) {
                            PyStrDictionary newDict = new PyStrDictionary((String)o);
                            dict.put(f, (Object)newDict);
                            dict = newDict;
                            continue;
                        }
                        dict = (PyStrDictionary)((Object)dict.get(f));
                        continue;
                    }
                    PyStrDictionary newDict = new PyStrDictionary();
                    dict.put(f, (Object)newDict);
                    dict = newDict;
                }
                String key = (String)fields.get(fields.size() - 1);
                if (dict.containsKey(key)) {
                    ((PyStrDictionary)((Object)dict.get(key))).setValue(e.getValue());
                    continue;
                }
                dict.put(key, e.getValue());
            }
        }
        return result;
    }

    public CheetahInterpreter(String cheetahScript, Map<String, String> variables) throws EoulsanException {
        Objects.requireNonNull(variables, "No variable set for Cheetah interpreter");
        Preconditions.checkState((!variables.isEmpty() ? 1 : 0) != 0, (Object)"Tool instance from Galaxy Tool not found variables for interpretation");
        this.cheetahScript = cheetahScript;
        this.variables = new HashMap<String, String>(variables);
    }

    private static class PyStrDictionary
    extends PyDictionary {
        private static final long serialVersionUID = 1L;
        private PyString value;

        public void setValue(String value) {
            this.value = new PyString(value);
        }

        public PyString __str__() {
            if (this.value != null) {
                return this.value;
            }
            return super.__str__();
        }

        public PyStrDictionary() {
        }

        public PyStrDictionary(String value) {
            this.setValue(value);
        }
    }
}

