/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.galaxytools.CheetahInterpreter;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolXMLParserUtils;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolExecutor;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolExecutorResult;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.DataToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ToolElement;
import fr.ens.biologie.genomique.kenetre.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GalaxyToolInterpreter {
    private final InputStream toolXMLis;
    private static final Set<String> TAG_FORBIDDEN = Sets.newHashSet((Object[])new String[]{"repeat"});
    private static final String TMP_DIR_VARIABLE_NAME = "TMPDIR";
    private static final String THREADS_VARIABLE_NAME = "THREADS";
    private final Document doc;
    private Map<String, ToolElement> inputs;
    private Map<String, ToolElement> outputs;
    private ElementPorts inputPorts;
    private ElementPorts outputPorts;
    private final ToolInfo toolInfo;
    private boolean isConfigured = false;
    private boolean isExecuted = false;

    public void configure(Set<Parameter> parameters) throws EoulsanException {
        Preconditions.checkState((!this.isConfigured ? 1 : 0) != 0, (Object)"GalaxyToolStep, this instance has been already configured");
        HashMap<String, Parameter> stepParameters = new HashMap<String, Parameter>();
        for (Parameter p : parameters) {
            stepParameters.put(p.getName(), p);
        }
        Document localDoc = this.doc;
        this.inputs = GalaxyToolXMLParserUtils.extractInputs(this.toolInfo, localDoc, stepParameters);
        this.outputs = GalaxyToolXMLParserUtils.extractOutputs(this.toolInfo, localDoc, stepParameters);
        this.inputPorts = new ElementPorts(this.inputs);
        this.outputPorts = new ElementPorts(this.outputs);
        this.isConfigured = true;
    }

    public ToolExecutorResult execute(TaskContext context) throws EoulsanException {
        Preconditions.checkState((!this.isExecuted ? 1 : 0) != 0, (Object)"this instance has been already executed");
        context.getLogger().info("Parsing xml file successfully.");
        context.getLogger().info("Tool description: " + this.toolInfo);
        int variablesCount = this.inputs.size() + this.outputs.size();
        HashMap<String, String> variables = new HashMap<String, String>(variablesCount);
        variables.put(TMP_DIR_VARIABLE_NAME, context.getLocalTempDirectory().getAbsolutePath());
        int threadNumber = context.getCurrentStep().getRequiredProcessors() > 0 ? context.getCurrentStep().getRequiredProcessors() : 1;
        variables.put(THREADS_VARIABLE_NAME, "" + threadNumber);
        HashSet<Data> inputDataSet = new HashSet<Data>();
        HashSet<File> inputFiles = new HashSet<File>();
        for (ToolElement e : this.inputs.values()) {
            if (e instanceof DataToolElement) {
                ElementPort inPort = this.inputPorts.getPortElements(e.getName());
                Data data = context.getInputData(inPort.portName);
                inputDataSet.add(data);
                File inFile = inPort.getInputDataFile(context).toFile();
                inputFiles.add(inFile);
                variables.put(e.getName(), inFile.getAbsolutePath());
                variables.put(GalaxyToolInterpreter.removeNamespace(e.getName()), inFile.getAbsolutePath());
                continue;
            }
            variables.put(e.getName(), e.getValue());
        }
        for (ToolElement e : this.outputs.values()) {
            if (e instanceof DataToolElement) {
                ElementPort outPort = this.outputPorts.getPortElements(e.getName());
                DataFile outFile = outPort.getOutputDataFile(context, this.selectSourceData(inputDataSet, context));
                variables.put(e.getName(), outFile.toFile().getAbsolutePath());
                variables.put(GalaxyToolInterpreter.removeNamespace(e.getName()), outFile.toFile().getAbsolutePath());
                continue;
            }
            variables.put(e.getName(), e.getValue());
        }
        if (variables.isEmpty()) {
            throw new EoulsanException("No variable set for Cheetah script.");
        }
        context.getLogger().info("Tool variables: " + Joiner.on((String)"\t").withKeyValueSeparator("=").join(variables));
        CheetahInterpreter cheetahInterpreter = new CheetahInterpreter(this.toolInfo.getCheetahScript(), variables);
        String commandLine = cheetahInterpreter.execute();
        context.getLogger().fine("Cheetah code execution output: " + this.toolInfo);
        try {
            ToolExecutor executor = new ToolExecutor(context, this.toolInfo, commandLine, inputFiles);
            ToolExecutorResult result = executor.execute();
            this.isExecuted = true;
            return result;
        }
        catch (IOException e) {
            this.isExecuted = true;
            throw new EoulsanException(e);
        }
    }

    private Document buildDOM() throws EoulsanException {
        Document document;
        block8: {
            InputStream in = this.toolXMLis;
            try {
                DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = dBuilder.parse(in);
                doc.getDocumentElement().normalize();
                document = doc;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new EoulsanException(e);
                }
            }
            in.close();
        }
        return document;
    }

    private void checkDomValidity() throws EoulsanException {
        for (String tag : TAG_FORBIDDEN) {
            if (XMLUtils.getElementsByTagName((Document)this.doc, (String)tag).isEmpty()) continue;
            throw new EoulsanException("Parsing tool xml: unsupported tag " + tag);
        }
    }

    private Data selectSourceData(Set<Data> inputDataSet, TaskContext context) {
        Data inData = null;
        for (Data data : inputDataSet) {
            if (inData == null) {
                inData = data;
                continue;
            }
            if (data.getFormat().isOneFilePerAnalysis()) continue;
            if (inData.getFormat().isOneFilePerAnalysis()) {
                inData = data;
                continue;
            }
            if (!this.isDataNameInDesign(data, context)) continue;
            inData = data;
        }
        return inData;
    }

    private boolean isDataNameInDesign(Data data, TaskContext context) {
        String dataName = data.getName();
        for (Sample sample : context.getWorkflow().getDesign().getSamples()) {
            if (!Naming.toValidName(sample.getId()).equals(dataName)) continue;
            return true;
        }
        return false;
    }

    public Map<String, ToolElement> getInputs() {
        return this.inputs;
    }

    public Map<String, ToolElement> getOutputs() {
        return this.outputs;
    }

    public Set<DataToolElement> getInputDataElements() {
        return this.inputPorts.getStepElements();
    }

    public Set<DataToolElement> getOutputDataElements() {
        return this.outputPorts.getStepElements();
    }

    public ToolInfo getToolInfo() {
        return this.toolInfo;
    }

    public String toString() {
        return "InterpreterToolGalaxy \n[inputs=" + Joiner.on((String)"\n").withKeyValueSeparator("=").join(this.inputs) + ", \noutputs=" + Joiner.on((String)"\n").withKeyValueSeparator("=").join(this.outputs) + ", \ntool=" + this.toolInfo + "]";
    }

    public static String removeNamespace(String variableName) {
        if (variableName == null) {
            return null;
        }
        int dotIndex = variableName.lastIndexOf(46);
        if (dotIndex == -1) {
            return variableName;
        }
        return variableName.substring(dotIndex + 1);
    }

    public GalaxyToolInterpreter(File file) throws EoulsanException, FileNotFoundException {
        this(new FileInputStream(file), file.getName());
    }

    public GalaxyToolInterpreter(InputStream in, String toolSource) throws EoulsanException {
        Objects.requireNonNull(in, "in argument cannot be null");
        this.toolXMLis = in;
        this.doc = this.buildDOM();
        this.toolInfo = new ToolInfo(this.doc, toolSource);
        this.checkDomValidity();
    }

    private static final class ElementPorts {
        private final Map<String, ElementPort> ports = new HashMap<String, ElementPort>();

        public ElementPort getPortElements(String elementName) {
            return this.ports.get(elementName);
        }

        public Set<DataToolElement> getStepElements() {
            HashSet<DataToolElement> result = new HashSet<DataToolElement>();
            for (ElementPort e : this.ports.values()) {
                if (e.fileIndex >= 1) continue;
                result.add(e.element);
            }
            return Collections.unmodifiableSet(result);
        }

        private static List<ToolElement> sortedElements(Collection<ToolElement> elements) {
            ArrayList<ToolElement> elementsSorted = new ArrayList<ToolElement>(elements);
            elementsSorted.sort(Comparator.comparing(ToolElement::getName));
            return Collections.unmodifiableList(elementsSorted);
        }

        public String toString() {
            return this.ports.toString();
        }

        public ElementPorts(Map<String, ToolElement> elements) {
            HashMultiset formatCount = HashMultiset.create();
            HashMap<DataFormat, String> formatPortNames = new HashMap<DataFormat, String>();
            for (ToolElement e : ElementPorts.sortedElements(elements.values())) {
                String portName;
                if (!(e instanceof DataToolElement)) continue;
                DataToolElement dataElement = (DataToolElement)e;
                DataFormat format = dataElement.getDataFormat();
                if (format.getMaxFilesCount() == 1) {
                    this.ports.put(e.getName(), new ElementPort(dataElement, e.getValidatedName(), -1));
                    continue;
                }
                if (formatPortNames.containsKey(format)) {
                    portName = (String)formatPortNames.get(format);
                } else {
                    portName = e.getValidatedName();
                    formatPortNames.put(format, portName);
                }
                this.ports.put(e.getName(), new ElementPort(dataElement, portName, formatCount.count((Object)format)));
                formatCount.add((Object)format);
            }
        }
    }

    private static final class ElementPort {
        private final DataToolElement element;
        private final String portName;
        private final int fileIndex;

        public DataFile getInputDataFile(TaskContext context) {
            Data data = context.getInputData(this.portName);
            return this.fileIndex == -1 ? data.getDataFile() : data.getDataFile(this.fileIndex);
        }

        public DataFile getOutputDataFile(TaskContext context, Data inData) {
            Data data = context.getOutputData(this.portName, inData);
            return this.fileIndex == -1 ? data.getDataFile() : data.getDataFile(this.fileIndex);
        }

        public String toString() {
            return "ElementPort{element=" + this.element.getName() + ", portName=" + this.portName + ", fileIndex=" + this.fileIndex + "}";
        }

        public ElementPort(DataToolElement element, String portName, int fileIndex) {
            this.element = element;
            this.portName = portName;
            this.fileIndex = fileIndex;
        }
    }
}

