/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ConditionalToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.DataToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ToolElementFactory;
import fr.ens.biologie.genomique.kenetre.util.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GalaxyToolXMLParserUtils {
    private static final String ID_TAG = "id";
    private static final String NAME_TAG = "name";
    private static final String VERSION_TAG = "version";
    private static final String TOOL_TAG = "tool";
    private static final String DESCRIPTION_TAG = "description";
    private static final String INTERPRETER_TAG = "interpreter";
    private static final String DOCKER_IMAGE_TAG = "dockerimage";
    private static final String COMMAND_TAG = "command";
    private static final String PARAM_TAG = "param";
    private static final String INPUTS_TAG = "inputs";
    private static final String DATA_TAG = "data";
    private static final String OUTPUTS_TAG = "outputs";
    private static final String CONDITIONAL = "conditional";

    public static Map<String, ToolElement> extractParamElement(ToolInfo toolInfo, Element parent, String elementName) throws EoulsanException {
        Map<String, Parameter> stepParameters = Collections.emptyMap();
        return GalaxyToolXMLParserUtils.extractParamElement(toolInfo, parent, elementName, stepParameters);
    }

    public static Map<String, ToolElement> extractParamElement(ToolInfo toolInfo, Element parent, String elementName, Map<String, Parameter> stepParameters) throws EoulsanException {
        HashMap<String, ToolElement> results = new HashMap<String, ToolElement>();
        List<Element> simpleParams = GalaxyToolXMLParserUtils.extractChildElementsByTagName(parent, elementName);
        for (Element param : simpleParams) {
            ToolElement toolElement = ToolElementFactory.newToolElement(toolInfo, param);
            GalaxyToolXMLParserUtils.setElementValue(toolElement, stepParameters);
            results.put(toolElement.getName(), toolElement);
        }
        return results;
    }

    public static void setElementValue(ToolElement toolElement, Map<String, Parameter> stepParameters) throws EoulsanException {
        if (!(toolElement instanceof DataToolElement)) {
            Parameter p = stepParameters.get(toolElement.getName());
            if (p == null) {
                p = stepParameters.get(toolElement.getShortName());
            }
            if (p != null) {
                toolElement.setValue(p.getStringValue());
            }
        }
    }

    public static Map<String, ToolElement> extractConditionalParamElement(ToolInfo toolInfo, Element parent) throws EoulsanException {
        Map<String, Parameter> stepParameters = Collections.emptyMap();
        return GalaxyToolXMLParserUtils.extractConditionalParamElement(toolInfo, parent, stepParameters);
    }

    public static Map<String, ToolElement> extractConditionalParamElement(ToolInfo toolInfo, Element parent, Map<String, Parameter> stepParameters) throws EoulsanException {
        HashMap<String, ToolElement> results = new HashMap<String, ToolElement>();
        List<Element> condParams = GalaxyToolXMLParserUtils.extractChildElementsByTagName(parent, CONDITIONAL);
        for (Element param : condParams) {
            ConditionalToolElement tce = new ConditionalToolElement(toolInfo, param);
            ToolElement parameterSelect = tce.getToolElementSelected();
            results.put(parameterSelect.getName(), parameterSelect);
            tce.setValues(stepParameters);
            results.putAll(tce.getToolElementsResult());
        }
        return results;
    }

    public static List<Element> extractElementsByTagName(ToolInfo toolInfo, Document doc, String tagName) throws EoulsanException {
        return GalaxyToolXMLParserUtils.extractElementsByTagName(toolInfo, doc, tagName, -1);
    }

    public static List<Element> extractElementsByTagName(ToolInfo toolInfo, Document doc, String tagName, int expectedCount) throws EoulsanException {
        List result = XMLUtils.getElementsByTagName((Document)doc, (String)tagName);
        if (expectedCount > 0) {
            if (result.isEmpty()) {
                throw new EoulsanException("Parsing tool XML file: no " + tagName + " tag found.");
            }
            if (result.size() != expectedCount) {
                throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, "invalid entry count found in \"" + tagName + "\" tag (expected " + expectedCount + " found " + result.size() + ")");
            }
        }
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public static EoulsanException newEoulsanException(ToolInfo toolInfo, String message) throws EoulsanException {
        return new EoulsanException("Error while parsing \"" + toolInfo.getToolSource() + "\" Galaxy tool file: " + message);
    }

    public static EoulsanException newEoulsanException(ToolInfo toolInfo, String parameterName, String message) throws EoulsanException {
        return new EoulsanException("Error while parsing \"" + parameterName + "\" parameter of the \"" + toolInfo.getToolSource() + "\" Galaxy tool file: " + message);
    }

    public static List<Element> extractElementsByTagName(Element parent, String tagName) throws EoulsanException {
        return GalaxyToolXMLParserUtils.extractElementsByTagName(parent, tagName, -1);
    }

    public static List<Element> extractElementsByTagName(Element parent, String tagName, int expectedCount) throws EoulsanException {
        List<Element> result = GalaxyToolXMLParserUtils.extractChildElementsByTagName(parent, tagName);
        if (expectedCount > 0) {
            if (result.isEmpty()) {
                throw new EoulsanException("Parsing tool XML file: no " + tagName + " tag found.");
            }
            if (result.size() != expectedCount) {
                throw new EoulsanException("Parsing tool XML file: tag " + tagName + " invalid entry count found (expected " + expectedCount + " founded " + result.size() + ".");
            }
        }
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public static List<Element> extractChildElementsByTagName(Element parentElement, String elementName) {
        if (elementName == null || parentElement == null) {
            return null;
        }
        NodeList nStepsList = parentElement.getChildNodes();
        if (nStepsList == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nStepsList.getLength(); ++i) {
            Element e;
            Node node = nStepsList.item(i);
            if (node == null || node.getNodeType() != 1 || !(e = (Element)node).getTagName().equals(elementName)) continue;
            result.add(e);
        }
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public static Map<String, ToolElement> extractOutputs(ToolInfo toolInfo, Document doc, Map<String, Parameter> stepParameters) throws EoulsanException {
        HashMap<String, ToolElement> results = new HashMap<String, ToolElement>();
        Element outputElement = GalaxyToolXMLParserUtils.extractElementsByTagName(toolInfo, doc, OUTPUTS_TAG, 1).get(0);
        results.putAll(GalaxyToolXMLParserUtils.extractParamElement(toolInfo, outputElement, DATA_TAG, stepParameters));
        results.putAll(GalaxyToolXMLParserUtils.extractConditionalParamElement(toolInfo, outputElement, stepParameters));
        return results;
    }

    public static Map<String, ToolElement> extractInputs(ToolInfo toolInfo, Document doc, Map<String, Parameter> stepParameters) throws EoulsanException {
        HashMap<String, ToolElement> results = new HashMap<String, ToolElement>();
        Element inputElement = GalaxyToolXMLParserUtils.extractElementsByTagName(toolInfo, doc, INPUTS_TAG, 1).get(0);
        results.putAll(GalaxyToolXMLParserUtils.extractParamElement(toolInfo, inputElement, PARAM_TAG, stepParameters));
        results.putAll(GalaxyToolXMLParserUtils.extractConditionalParamElement(toolInfo, inputElement, stepParameters));
        return results;
    }

    public static String extractCheetahScript(Document doc) {
        return GalaxyToolXMLParserUtils.extractValueFromElement(doc, COMMAND_TAG, 0, null);
    }

    public static List<String> extractInterpreters(Document doc) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : Splitter.on((char)',').trimResults().split((CharSequence)GalaxyToolXMLParserUtils.extractValueFromElement(doc, COMMAND_TAG, 0, INTERPRETER_TAG))) {
            result.add(s);
        }
        return result;
    }

    public static String extractDockerImage(Document doc) {
        return GalaxyToolXMLParserUtils.extractValueFromElement(doc, COMMAND_TAG, 0, DOCKER_IMAGE_TAG);
    }

    public static String extractDescription(Document doc) {
        return GalaxyToolXMLParserUtils.extractValueFromElement(doc, DESCRIPTION_TAG, 0, null);
    }

    public static String extractToolVersion(Document doc) {
        return GalaxyToolXMLParserUtils.extractValueFromElement(doc, TOOL_TAG, 0, VERSION_TAG);
    }

    public static String extractToolName(Document doc) {
        return GalaxyToolXMLParserUtils.extractValueFromElement(doc, TOOL_TAG, 0, NAME_TAG);
    }

    public static String extractToolID(Document doc) {
        return GalaxyToolXMLParserUtils.extractValueFromElement(doc, TOOL_TAG, 0, ID_TAG);
    }

    public static String extractValueFromElement(Document doc, String elementName, int index, String attributeName) {
        List e = XMLUtils.getElementsByTagName((Document)doc, (String)elementName);
        if (e.isEmpty()) {
            return null;
        }
        if (index >= e.size()) {
            return null;
        }
        if (attributeName == null) {
            return ((Element)e.get(index)).getTextContent();
        }
        return ((Element)e.get(index)).getAttribute(attributeName);
    }
}

