/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolExecutorResult;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters.AbstractExecutorInterpreter;
import fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters.DefaultExecutorInterpreter;
import fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters.DockerExecutorInterpreter;
import fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters.GenericExecutorInterpreter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ToolExecutor {
    private static final String STDOUT_SUFFIX = ".galaxytool.out";
    private static final String STDERR_SUFFIX = ".galaxytool.err";
    private final TaskContext stepContext;
    private final ToolInfo toolData;
    private final String commandLine;
    private final Set<File> inputFiles;

    ToolExecutorResult execute() throws IOException {
        AbstractExecutorInterpreter ti;
        String interpreter;
        Preconditions.checkArgument((!this.commandLine.isEmpty() ? 1 : 0) != 0, (Object)"Command line for Galaxy tool is empty");
        switch (interpreter = this.toolData.getInterpreter(this.stepContext.getSettings().isDockerConnectionDefined())) {
            case "": 
            case "default": {
                ti = new DefaultExecutorInterpreter();
                break;
            }
            case "docker": {
                ti = new DockerExecutorInterpreter(this.toolData.getDockerImage());
                break;
            }
            default: {
                ti = new GenericExecutorInterpreter(interpreter);
            }
        }
        List<String> command = ti.createCommandLine(this.commandLine);
        TaskContextImpl context = (TaskContextImpl)this.stepContext;
        File executionDirectory = context.getStepOutputDirectory().toFile();
        File workflowOutputDirectory = context.getOutputDirectory().toFile();
        File logDirectory = context.getTaskOutputDirectory().toFile();
        File tempDirectory = context.getLocalTempDirectory();
        File stdoutFile = new File(logDirectory, context.getTaskFilePrefix() + STDOUT_SUFFIX);
        File stderrFile = new File(logDirectory, context.getTaskFilePrefix() + STDERR_SUFFIX);
        EoulsanLogger.getLogger().info("Interpreter: " + interpreter);
        EoulsanLogger.getLogger().info("Command: " + command);
        EoulsanLogger.getLogger().info("Execution directory: " + executionDirectory);
        EoulsanLogger.getLogger().info("Workflow output directory: " + workflowOutputDirectory);
        EoulsanLogger.getLogger().info("Temporary directory: " + tempDirectory);
        EoulsanLogger.getLogger().info("Stdout: " + stdoutFile);
        EoulsanLogger.getLogger().info("Stderr: " + stderrFile);
        return ti.execute(command, executionDirectory, tempDirectory, stdoutFile, stderrFile, ToolExecutor.toArray(this.inputFiles, workflowOutputDirectory));
    }

    private static File[] toArray(Collection<File> collection, File ... files) {
        ArrayList<File> list = new ArrayList<File>(collection);
        if (files != null) {
            list.addAll(Arrays.asList(files));
        }
        return list.toArray(new File[0]);
    }

    public ToolExecutor(TaskContext context, ToolInfo toolData, String commandLine, Set<File> inputFiles) throws IOException {
        Objects.requireNonNull(commandLine, "commandLine is null.");
        Objects.requireNonNull(context, "Step context is null.");
        this.toolData = toolData;
        this.commandLine = commandLine.trim();
        this.stepContext = context;
        this.inputFiles = inputFiles;
    }
}

